package zio.aws.config.model
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{RuleLimit, ConfigRuleName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeConfigRuleEvaluationStatusRequest(
    configRuleNames: Optional[Iterable[ConfigRuleName]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    limit: Optional[RuleLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest = {
    import DescribeConfigRuleEvaluationStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest
      .builder()
      .optionallyWith(
        configRuleNames.map(value =>
          value.map { item =>
            ConfigRuleName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.configRuleNames)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(limit.map(value => RuleLimit.unwrap(value): Integer))(
        _.limit
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeConfigRuleEvaluationStatusRequest.ReadOnly =
    zio.aws.config.model.DescribeConfigRuleEvaluationStatusRequest
      .wrap(buildAwsValue())
}
object DescribeConfigRuleEvaluationStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeConfigRuleEvaluationStatusRequest =
      zio.aws.config.model.DescribeConfigRuleEvaluationStatusRequest(
        configRuleNames.map(value => value),
        nextToken.map(value => value),
        limit.map(value => value)
      )
    def configRuleNames: Optional[List[ConfigRuleName]]
    def nextToken: Optional[String]
    def limit: Optional[RuleLimit]
    def getConfigRuleNames: ZIO[Any, AwsError, List[ConfigRuleName]] =
      AwsError.unwrapOptionField("configRuleNames", configRuleNames)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLimit: ZIO[Any, AwsError, RuleLimit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest
  ) extends zio.aws.config.model.DescribeConfigRuleEvaluationStatusRequest.ReadOnly {
    override val configRuleNames: Optional[List[ConfigRuleName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configRuleNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.primitives.ConfigRuleName(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val limit: Optional[RuleLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.config.model.primitives.RuleLimit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest
  ): zio.aws.config.model.DescribeConfigRuleEvaluationStatusRequest.ReadOnly =
    new Wrapper(impl)
}
