package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeConformancePacksResponse(
    conformancePackDetails: Optional[
      Iterable[zio.aws.config.model.ConformancePackDetail]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse = {
    import DescribeConformancePacksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse
      .builder()
      .optionallyWith(
        conformancePackDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.conformancePackDetails)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeConformancePacksResponse.ReadOnly =
    zio.aws.config.model.DescribeConformancePacksResponse.wrap(buildAwsValue())
}
object DescribeConformancePacksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DescribeConformancePacksResponse =
      zio.aws.config.model.DescribeConformancePacksResponse(
        conformancePackDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def conformancePackDetails
        : Optional[List[zio.aws.config.model.ConformancePackDetail.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getConformancePackDetails: ZIO[Any, AwsError, List[
      zio.aws.config.model.ConformancePackDetail.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "conformancePackDetails",
      conformancePackDetails
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse
  ) extends zio.aws.config.model.DescribeConformancePacksResponse.ReadOnly {
    override val conformancePackDetails
        : Optional[List[zio.aws.config.model.ConformancePackDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conformancePackDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.ConformancePackDetail.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse
  ): zio.aws.config.model.DescribeConformancePacksResponse.ReadOnly =
    new Wrapper(impl)
}
