package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{SSMDocumentVersion, SSMDocumentName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TemplateSSMDocumentDetails(
    documentName: SSMDocumentName,
    documentVersion: Optional[SSMDocumentVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.TemplateSSMDocumentDetails = {
    import TemplateSSMDocumentDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.TemplateSSMDocumentDetails
      .builder()
      .documentName(SSMDocumentName.unwrap(documentName): java.lang.String)
      .optionallyWith(
        documentVersion.map(value =>
          SSMDocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .build()
  }
  def asReadOnly: zio.aws.config.model.TemplateSSMDocumentDetails.ReadOnly =
    zio.aws.config.model.TemplateSSMDocumentDetails.wrap(buildAwsValue())
}
object TemplateSSMDocumentDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.TemplateSSMDocumentDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.TemplateSSMDocumentDetails =
      zio.aws.config.model.TemplateSSMDocumentDetails(
        documentName,
        documentVersion.map(value => value)
      )
    def documentName: SSMDocumentName
    def documentVersion: Optional[SSMDocumentVersion]
    def getDocumentName: ZIO[Any, Nothing, SSMDocumentName] =
      ZIO.succeed(documentName)
    def getDocumentVersion: ZIO[Any, AwsError, SSMDocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.TemplateSSMDocumentDetails
  ) extends zio.aws.config.model.TemplateSSMDocumentDetails.ReadOnly {
    override val documentName: SSMDocumentName =
      zio.aws.config.model.primitives.SSMDocumentName(impl.documentName())
    override val documentVersion: Optional[SSMDocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.config.model.primitives.SSMDocumentVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.TemplateSSMDocumentDetails
  ): zio.aws.config.model.TemplateSSMDocumentDetails.ReadOnly = new Wrapper(
    impl
  )
}
