package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutDeliveryChannelRequest(
    deliveryChannel: zio.aws.config.model.DeliveryChannel
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutDeliveryChannelRequest = {
    import PutDeliveryChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutDeliveryChannelRequest
      .builder()
      .deliveryChannel(deliveryChannel.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.config.model.PutDeliveryChannelRequest.ReadOnly =
    zio.aws.config.model.PutDeliveryChannelRequest.wrap(buildAwsValue())
}
object PutDeliveryChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutDeliveryChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutDeliveryChannelRequest =
      zio.aws.config.model.PutDeliveryChannelRequest(deliveryChannel.asEditable)
    def deliveryChannel: zio.aws.config.model.DeliveryChannel.ReadOnly
    def getDeliveryChannel
        : ZIO[Any, Nothing, zio.aws.config.model.DeliveryChannel.ReadOnly] =
      ZIO.succeed(deliveryChannel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutDeliveryChannelRequest
  ) extends zio.aws.config.model.PutDeliveryChannelRequest.ReadOnly {
    override val deliveryChannel
        : zio.aws.config.model.DeliveryChannel.ReadOnly =
      zio.aws.config.model.DeliveryChannel.wrap(impl.deliveryChannel())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutDeliveryChannelRequest
  ): zio.aws.config.model.PutDeliveryChannelRequest.ReadOnly = new Wrapper(impl)
}
