package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  StringWithCharLimit2048,
  StringWithCharLimit256,
  StringWithCharLimit128,
  StringWithCharLimit768,
  StringWithCharLimit256Min0
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OrganizationManagedRuleMetadata(
    description: Optional[StringWithCharLimit256Min0] = Optional.Absent,
    ruleIdentifier: StringWithCharLimit256,
    inputParameters: Optional[StringWithCharLimit2048] = Optional.Absent,
    maximumExecutionFrequency: Optional[
      zio.aws.config.model.MaximumExecutionFrequency
    ] = Optional.Absent,
    resourceTypesScope: Optional[Iterable[StringWithCharLimit256]] =
      Optional.Absent,
    resourceIdScope: Optional[StringWithCharLimit768] = Optional.Absent,
    tagKeyScope: Optional[StringWithCharLimit128] = Optional.Absent,
    tagValueScope: Optional[StringWithCharLimit256] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.OrganizationManagedRuleMetadata = {
    import OrganizationManagedRuleMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.OrganizationManagedRuleMetadata
      .builder()
      .optionallyWith(
        description.map(value =>
          StringWithCharLimit256Min0.unwrap(value): java.lang.String
        )
      )(_.description)
      .ruleIdentifier(
        StringWithCharLimit256.unwrap(ruleIdentifier): java.lang.String
      )
      .optionallyWith(
        inputParameters.map(value =>
          StringWithCharLimit2048.unwrap(value): java.lang.String
        )
      )(_.inputParameters)
      .optionallyWith(maximumExecutionFrequency.map(value => value.unwrap))(
        _.maximumExecutionFrequency
      )
      .optionallyWith(
        resourceTypesScope.map(value =>
          value.map { item =>
            StringWithCharLimit256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypesScope)
      .optionallyWith(
        resourceIdScope.map(value =>
          StringWithCharLimit768.unwrap(value): java.lang.String
        )
      )(_.resourceIdScope)
      .optionallyWith(
        tagKeyScope.map(value =>
          StringWithCharLimit128.unwrap(value): java.lang.String
        )
      )(_.tagKeyScope)
      .optionallyWith(
        tagValueScope.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.tagValueScope)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.OrganizationManagedRuleMetadata.ReadOnly =
    zio.aws.config.model.OrganizationManagedRuleMetadata.wrap(buildAwsValue())
}
object OrganizationManagedRuleMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.OrganizationManagedRuleMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.OrganizationManagedRuleMetadata =
      zio.aws.config.model.OrganizationManagedRuleMetadata(
        description.map(value => value),
        ruleIdentifier,
        inputParameters.map(value => value),
        maximumExecutionFrequency.map(value => value),
        resourceTypesScope.map(value => value),
        resourceIdScope.map(value => value),
        tagKeyScope.map(value => value),
        tagValueScope.map(value => value)
      )
    def description: Optional[StringWithCharLimit256Min0]
    def ruleIdentifier: StringWithCharLimit256
    def inputParameters: Optional[StringWithCharLimit2048]
    def maximumExecutionFrequency
        : Optional[zio.aws.config.model.MaximumExecutionFrequency]
    def resourceTypesScope: Optional[List[StringWithCharLimit256]]
    def resourceIdScope: Optional[StringWithCharLimit768]
    def tagKeyScope: Optional[StringWithCharLimit128]
    def tagValueScope: Optional[StringWithCharLimit256]
    def getDescription: ZIO[Any, AwsError, StringWithCharLimit256Min0] =
      AwsError.unwrapOptionField("description", description)
    def getRuleIdentifier: ZIO[Any, Nothing, StringWithCharLimit256] =
      ZIO.succeed(ruleIdentifier)
    def getInputParameters: ZIO[Any, AwsError, StringWithCharLimit2048] =
      AwsError.unwrapOptionField("inputParameters", inputParameters)
    def getMaximumExecutionFrequency
        : ZIO[Any, AwsError, zio.aws.config.model.MaximumExecutionFrequency] =
      AwsError.unwrapOptionField(
        "maximumExecutionFrequency",
        maximumExecutionFrequency
      )
    def getResourceTypesScope
        : ZIO[Any, AwsError, List[StringWithCharLimit256]] =
      AwsError.unwrapOptionField("resourceTypesScope", resourceTypesScope)
    def getResourceIdScope: ZIO[Any, AwsError, StringWithCharLimit768] =
      AwsError.unwrapOptionField("resourceIdScope", resourceIdScope)
    def getTagKeyScope: ZIO[Any, AwsError, StringWithCharLimit128] =
      AwsError.unwrapOptionField("tagKeyScope", tagKeyScope)
    def getTagValueScope: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("tagValueScope", tagValueScope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.OrganizationManagedRuleMetadata
  ) extends zio.aws.config.model.OrganizationManagedRuleMetadata.ReadOnly {
    override val description: Optional[StringWithCharLimit256Min0] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit256Min0(value)
        )
    override val ruleIdentifier: StringWithCharLimit256 =
      zio.aws.config.model.primitives
        .StringWithCharLimit256(impl.ruleIdentifier())
    override val inputParameters: Optional[StringWithCharLimit2048] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputParameters())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit2048(value)
        )
    override val maximumExecutionFrequency
        : Optional[zio.aws.config.model.MaximumExecutionFrequency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumExecutionFrequency())
        .map(value =>
          zio.aws.config.model.MaximumExecutionFrequency.wrap(value)
        )
    override val resourceTypesScope: Optional[List[StringWithCharLimit256]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTypesScope())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.primitives.StringWithCharLimit256(item)
          }.toList
        )
    override val resourceIdScope: Optional[StringWithCharLimit768] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceIdScope())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit768(value)
        )
    override val tagKeyScope: Optional[StringWithCharLimit128] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagKeyScope())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit128(value)
        )
    override val tagValueScope: Optional[StringWithCharLimit256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagValueScope())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit256(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.OrganizationManagedRuleMetadata
  ): zio.aws.config.model.OrganizationManagedRuleMetadata.ReadOnly =
    new Wrapper(impl)
}
