package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.ChannelName
import scala.jdk.CollectionConverters.*
final case class DeliverConfigSnapshotRequest(
    deliveryChannelName: ChannelName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DeliverConfigSnapshotRequest = {
    import DeliverConfigSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DeliverConfigSnapshotRequest
      .builder()
      .deliveryChannelName(
        ChannelName.unwrap(deliveryChannelName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.DeliverConfigSnapshotRequest.ReadOnly =
    zio.aws.config.model.DeliverConfigSnapshotRequest.wrap(buildAwsValue())
}
object DeliverConfigSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DeliverConfigSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DeliverConfigSnapshotRequest =
      zio.aws.config.model.DeliverConfigSnapshotRequest(deliveryChannelName)
    def deliveryChannelName: ChannelName
    def getDeliveryChannelName: ZIO[Any, Nothing, ChannelName] =
      ZIO.succeed(deliveryChannelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DeliverConfigSnapshotRequest
  ) extends zio.aws.config.model.DeliverConfigSnapshotRequest.ReadOnly {
    override val deliveryChannelName: ChannelName =
      zio.aws.config.model.primitives.ChannelName(impl.deliveryChannelName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DeliverConfigSnapshotRequest
  ): zio.aws.config.model.DeliverConfigSnapshotRequest.ReadOnly = new Wrapper(
    impl
  )
}
