package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.Date
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ConfigurationRecorderStatus(
    name: Optional[String] = Optional.Absent,
    lastStartTime: Optional[Date] = Optional.Absent,
    lastStopTime: Optional[Date] = Optional.Absent,
    recording: Optional[Boolean] = Optional.Absent,
    lastStatus: Optional[zio.aws.config.model.RecorderStatus] = Optional.Absent,
    lastErrorCode: Optional[String] = Optional.Absent,
    lastErrorMessage: Optional[String] = Optional.Absent,
    lastStatusChangeTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConfigurationRecorderStatus = {
    import ConfigurationRecorderStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConfigurationRecorderStatus
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(lastStartTime.map(value => Date.unwrap(value): Instant))(
        _.lastStartTime
      )
      .optionallyWith(lastStopTime.map(value => Date.unwrap(value): Instant))(
        _.lastStopTime
      )
      .optionallyWith(recording.map(value => value: java.lang.Boolean))(
        _.recording
      )
      .optionallyWith(lastStatus.map(value => value.unwrap))(_.lastStatus)
      .optionallyWith(lastErrorCode.map(value => value: java.lang.String))(
        _.lastErrorCode
      )
      .optionallyWith(lastErrorMessage.map(value => value: java.lang.String))(
        _.lastErrorMessage
      )
      .optionallyWith(
        lastStatusChangeTime.map(value => Date.unwrap(value): Instant)
      )(_.lastStatusChangeTime)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ConfigurationRecorderStatus.ReadOnly =
    zio.aws.config.model.ConfigurationRecorderStatus.wrap(buildAwsValue())
}
object ConfigurationRecorderStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConfigurationRecorderStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConfigurationRecorderStatus =
      zio.aws.config.model.ConfigurationRecorderStatus(
        name.map(value => value),
        lastStartTime.map(value => value),
        lastStopTime.map(value => value),
        recording.map(value => value),
        lastStatus.map(value => value),
        lastErrorCode.map(value => value),
        lastErrorMessage.map(value => value),
        lastStatusChangeTime.map(value => value)
      )
    def name: Optional[String]
    def lastStartTime: Optional[Date]
    def lastStopTime: Optional[Date]
    def recording: Optional[Boolean]
    def lastStatus: Optional[zio.aws.config.model.RecorderStatus]
    def lastErrorCode: Optional[String]
    def lastErrorMessage: Optional[String]
    def lastStatusChangeTime: Optional[Date]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getLastStartTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastStartTime", lastStartTime)
    def getLastStopTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastStopTime", lastStopTime)
    def getRecording: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("recording", recording)
    def getLastStatus: ZIO[Any, AwsError, zio.aws.config.model.RecorderStatus] =
      AwsError.unwrapOptionField("lastStatus", lastStatus)
    def getLastErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastErrorCode", lastErrorCode)
    def getLastErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastErrorMessage", lastErrorMessage)
    def getLastStatusChangeTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastStatusChangeTime", lastStatusChangeTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConfigurationRecorderStatus
  ) extends zio.aws.config.model.ConfigurationRecorderStatus.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val lastStartTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStartTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val lastStopTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStopTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val recording: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.recording())
      .map(value => value: Boolean)
    override val lastStatus: Optional[zio.aws.config.model.RecorderStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastStatus())
        .map(value => zio.aws.config.model.RecorderStatus.wrap(value))
    override val lastErrorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastErrorCode())
      .map(value => value: String)
    override val lastErrorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastErrorMessage())
      .map(value => value: String)
    override val lastStatusChangeTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStatusChangeTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConfigurationRecorderStatus
  ): zio.aws.config.model.ConfigurationRecorderStatus.ReadOnly = new Wrapper(
    impl
  )
}
