package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.StringWithCharLimit256
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AggregateConformancePackComplianceSummary(
    complianceSummary: Optional[
      zio.aws.config.model.AggregateConformancePackComplianceCount
    ] = Optional.Absent,
    groupName: Optional[StringWithCharLimit256] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.AggregateConformancePackComplianceSummary = {
    import AggregateConformancePackComplianceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.AggregateConformancePackComplianceSummary
      .builder()
      .optionallyWith(complianceSummary.map(value => value.buildAwsValue()))(
        _.complianceSummary
      )
      .optionallyWith(
        groupName.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.AggregateConformancePackComplianceSummary.ReadOnly =
    zio.aws.config.model.AggregateConformancePackComplianceSummary
      .wrap(buildAwsValue())
}
object AggregateConformancePackComplianceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.AggregateConformancePackComplianceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.AggregateConformancePackComplianceSummary =
      zio.aws.config.model.AggregateConformancePackComplianceSummary(
        complianceSummary.map(value => value.asEditable),
        groupName.map(value => value)
      )
    def complianceSummary: Optional[
      zio.aws.config.model.AggregateConformancePackComplianceCount.ReadOnly
    ]
    def groupName: Optional[StringWithCharLimit256]
    def getComplianceSummary: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.AggregateConformancePackComplianceCount.ReadOnly
    ] = AwsError.unwrapOptionField("complianceSummary", complianceSummary)
    def getGroupName: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("groupName", groupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.AggregateConformancePackComplianceSummary
  ) extends zio.aws.config.model.AggregateConformancePackComplianceSummary.ReadOnly {
    override val complianceSummary: Optional[
      zio.aws.config.model.AggregateConformancePackComplianceCount.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.complianceSummary())
      .map(value =>
        zio.aws.config.model.AggregateConformancePackComplianceCount.wrap(value)
      )
    override val groupName: Optional[StringWithCharLimit256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupName())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit256(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.AggregateConformancePackComplianceSummary
  ): zio.aws.config.model.AggregateConformancePackComplianceSummary.ReadOnly =
    new Wrapper(impl)
}
