package zio.aws.config
import zio.aws.config.model.DeleteStoredQueryResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.config.model.{
  DeleteConfigurationAggregatorRequest,
  PutRemediationConfigurationsRequest,
  GetAggregateConfigRuleComplianceSummaryRequest,
  DescribeRemediationExceptionsRequest,
  GetConformancePackComplianceDetailsRequest,
  DescribeComplianceByConfigRuleRequest,
  DeleteStoredQueryRequest,
  DescribeConformancePacksRequest,
  DescribeAggregateComplianceByConfigRulesRequest,
  ListAggregateDiscoveredResourcesRequest,
  DeleteRemediationExceptionsRequest,
  DescribeConformancePackComplianceRequest,
  GetDiscoveredResourceCountsRequest,
  DescribeOrganizationConformancePackStatusesRequest,
  StopConfigurationRecorderRequest,
  PutExternalEvaluationRequest,
  GetAggregateComplianceDetailsByConfigRuleRequest,
  DeleteRemediationConfigurationRequest,
  PutConformancePackRequest,
  SelectAggregateResourceConfigRequest,
  GetOrganizationConformancePackDetailedStatusRequest,
  DescribeConfigRuleEvaluationStatusRequest,
  GetAggregateConformancePackComplianceSummaryRequest,
  BatchGetResourceConfigRequest,
  ListStoredQueriesRequest,
  PutOrganizationConfigRuleRequest,
  DescribeOrganizationConformancePacksRequest,
  DescribeConfigurationRecorderStatusRequest,
  GetComplianceDetailsByResourceRequest,
  DescribeConfigRulesRequest,
  ListTagsForResourceRequest,
  DescribeRemediationExecutionStatusRequest,
  PutConfigRuleRequest,
  DescribeRetentionConfigurationsRequest,
  GetComplianceSummaryByResourceTypeRequest,
  DeleteOrganizationConformancePackRequest,
  DescribeComplianceByResourceRequest,
  DescribeDeliveryChannelStatusRequest,
  DescribeConfigurationRecordersRequest,
  StartRemediationExecutionRequest,
  GetOrganizationConfigRuleDetailedStatusRequest,
  PutResourceConfigRequest,
  DeleteConformancePackRequest,
  DeleteAggregationAuthorizationRequest,
  DeleteEvaluationResultsRequest,
  DescribeConfigurationAggregatorsRequest,
  GetComplianceDetailsByConfigRuleRequest,
  PutEvaluationsRequest,
  ListConformancePackComplianceScoresRequest,
  DescribeConformancePackStatusRequest,
  DescribeAggregationAuthorizationsRequest,
  ListDiscoveredResourcesRequest,
  GetAggregateResourceConfigRequest,
  DeleteResourceConfigRequest,
  DeleteDeliveryChannelRequest,
  PutRemediationExceptionsRequest,
  DescribeOrganizationConfigRulesRequest,
  PutConfigurationRecorderRequest,
  GetResourceConfigHistoryRequest,
  StartConfigRulesEvaluationRequest,
  DeliverConfigSnapshotRequest,
  UntagResourceRequest,
  StartConfigurationRecorderRequest,
  PutOrganizationConformancePackRequest,
  PutAggregationAuthorizationRequest,
  DeleteRetentionConfigurationRequest,
  DescribeConfigurationAggregatorSourcesStatusRequest,
  GetOrganizationCustomRulePolicyRequest,
  GetCustomRulePolicyRequest,
  GetAggregateDiscoveredResourceCountsRequest,
  GetStoredQueryRequest,
  DescribeRemediationConfigurationsRequest,
  DescribeDeliveryChannelsRequest,
  DeletePendingAggregationRequestRequest,
  PutRetentionConfigurationRequest,
  DescribeAggregateComplianceByConformancePacksRequest,
  PutStoredQueryRequest,
  DeleteOrganizationConfigRuleRequest,
  DescribeOrganizationConfigRuleStatusesRequest,
  GetConformancePackComplianceSummaryRequest,
  BatchGetAggregateResourceConfigRequest,
  DeleteConfigRuleRequest,
  PutConfigurationAggregatorRequest,
  SelectResourceConfigRequest,
  TagResourceRequest,
  DeleteConfigurationRecorderRequest,
  DescribePendingAggregationRequestsRequest,
  PutDeliveryChannelRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.config.ConfigAsyncClient
object ConfigMock extends Mock[Config] {
  object DeleteRemediationExceptions
      extends Effect[
        DeleteRemediationExceptionsRequest,
        AwsError,
        zio.aws.config.model.DeleteRemediationExceptionsResponse.ReadOnly
      ]
  object DescribeComplianceByConfigRule
      extends Stream[
        DescribeComplianceByConfigRuleRequest,
        AwsError,
        zio.aws.config.model.ComplianceByConfigRule.ReadOnly
      ]
  object DescribeComplianceByConfigRulePaginated
      extends Effect[
        DescribeComplianceByConfigRuleRequest,
        AwsError,
        zio.aws.config.model.DescribeComplianceByConfigRuleResponse.ReadOnly
      ]
  object PutConfigurationAggregator
      extends Effect[
        PutConfigurationAggregatorRequest,
        AwsError,
        zio.aws.config.model.PutConfigurationAggregatorResponse.ReadOnly
      ]
  object GetComplianceSummaryByConfigRule
      extends Effect[
        Unit,
        AwsError,
        zio.aws.config.model.GetComplianceSummaryByConfigRuleResponse.ReadOnly
      ]
  object GetAggregateConfigRuleComplianceSummary
      extends Effect[
        GetAggregateConfigRuleComplianceSummaryRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse.ReadOnly,
          zio.aws.config.model.AggregateComplianceCount.ReadOnly
        ]
      ]
  object GetAggregateConfigRuleComplianceSummaryPaginated
      extends Effect[
        GetAggregateConfigRuleComplianceSummaryRequest,
        AwsError,
        zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse.ReadOnly
      ]
  object DescribeDeliveryChannelStatus
      extends Effect[
        DescribeDeliveryChannelStatusRequest,
        AwsError,
        zio.aws.config.model.DescribeDeliveryChannelStatusResponse.ReadOnly
      ]
  object DescribeAggregationAuthorizations
      extends Stream[
        DescribeAggregationAuthorizationsRequest,
        AwsError,
        zio.aws.config.model.AggregationAuthorization.ReadOnly
      ]
  object DescribeAggregationAuthorizationsPaginated
      extends Effect[
        DescribeAggregationAuthorizationsRequest,
        AwsError,
        zio.aws.config.model.DescribeAggregationAuthorizationsResponse.ReadOnly
      ]
  object GetOrganizationConfigRuleDetailedStatus
      extends Stream[
        GetOrganizationConfigRuleDetailedStatusRequest,
        AwsError,
        zio.aws.config.model.MemberAccountStatus.ReadOnly
      ]
  object GetOrganizationConfigRuleDetailedStatusPaginated
      extends Effect[
        GetOrganizationConfigRuleDetailedStatusRequest,
        AwsError,
        zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusResponse.ReadOnly
      ]
  object StartConfigRulesEvaluation
      extends Effect[
        StartConfigRulesEvaluationRequest,
        AwsError,
        zio.aws.config.model.StartConfigRulesEvaluationResponse.ReadOnly
      ]
  object DescribeOrganizationConfigRuleStatuses
      extends Stream[
        DescribeOrganizationConfigRuleStatusesRequest,
        AwsError,
        zio.aws.config.model.OrganizationConfigRuleStatus.ReadOnly
      ]
  object DescribeOrganizationConfigRuleStatusesPaginated
      extends Effect[
        DescribeOrganizationConfigRuleStatusesRequest,
        AwsError,
        zio.aws.config.model.DescribeOrganizationConfigRuleStatusesResponse.ReadOnly
      ]
  object StopConfigurationRecorder
      extends Effect[StopConfigurationRecorderRequest, AwsError, Unit]
  object PutConfigurationRecorder
      extends Effect[PutConfigurationRecorderRequest, AwsError, Unit]
  object DeleteOrganizationConformancePack
      extends Effect[DeleteOrganizationConformancePackRequest, AwsError, Unit]
  object DescribeConfigRuleEvaluationStatus
      extends Stream[
        DescribeConfigRuleEvaluationStatusRequest,
        AwsError,
        zio.aws.config.model.ConfigRuleEvaluationStatus.ReadOnly
      ]
  object DescribeConfigRuleEvaluationStatusPaginated
      extends Effect[
        DescribeConfigRuleEvaluationStatusRequest,
        AwsError,
        zio.aws.config.model.DescribeConfigRuleEvaluationStatusResponse.ReadOnly
      ]
  object DescribeOrganizationConformancePackStatuses
      extends Stream[
        DescribeOrganizationConformancePackStatusesRequest,
        AwsError,
        zio.aws.config.model.OrganizationConformancePackStatus.ReadOnly
      ]
  object DescribeOrganizationConformancePackStatusesPaginated
      extends Effect[
        DescribeOrganizationConformancePackStatusesRequest,
        AwsError,
        zio.aws.config.model.DescribeOrganizationConformancePackStatusesResponse.ReadOnly
      ]
  object DescribeConfigurationAggregators
      extends Stream[
        DescribeConfigurationAggregatorsRequest,
        AwsError,
        zio.aws.config.model.ConfigurationAggregator.ReadOnly
      ]
  object DescribeConfigurationAggregatorsPaginated
      extends Effect[
        DescribeConfigurationAggregatorsRequest,
        AwsError,
        zio.aws.config.model.DescribeConfigurationAggregatorsResponse.ReadOnly
      ]
  object DescribeDeliveryChannels
      extends Effect[
        DescribeDeliveryChannelsRequest,
        AwsError,
        zio.aws.config.model.DescribeDeliveryChannelsResponse.ReadOnly
      ]
  object DeleteOrganizationConfigRule
      extends Effect[DeleteOrganizationConfigRuleRequest, AwsError, Unit]
  object PutDeliveryChannel
      extends Effect[PutDeliveryChannelRequest, AwsError, Unit]
  object ListAggregateDiscoveredResources
      extends Stream[
        ListAggregateDiscoveredResourcesRequest,
        AwsError,
        zio.aws.config.model.AggregateResourceIdentifier.ReadOnly
      ]
  object ListAggregateDiscoveredResourcesPaginated
      extends Effect[
        ListAggregateDiscoveredResourcesRequest,
        AwsError,
        zio.aws.config.model.ListAggregateDiscoveredResourcesResponse.ReadOnly
      ]
  object DescribePendingAggregationRequests
      extends Stream[
        DescribePendingAggregationRequestsRequest,
        AwsError,
        zio.aws.config.model.PendingAggregationRequest.ReadOnly
      ]
  object DescribePendingAggregationRequestsPaginated
      extends Effect[
        DescribePendingAggregationRequestsRequest,
        AwsError,
        zio.aws.config.model.DescribePendingAggregationRequestsResponse.ReadOnly
      ]
  object DescribeAggregateComplianceByConfigRules
      extends Stream[
        DescribeAggregateComplianceByConfigRulesRequest,
        AwsError,
        zio.aws.config.model.AggregateComplianceByConfigRule.ReadOnly
      ]
  object DescribeAggregateComplianceByConfigRulesPaginated
      extends Effect[
        DescribeAggregateComplianceByConfigRulesRequest,
        AwsError,
        zio.aws.config.model.DescribeAggregateComplianceByConfigRulesResponse.ReadOnly
      ]
  object DeleteEvaluationResults
      extends Effect[
        DeleteEvaluationResultsRequest,
        AwsError,
        zio.aws.config.model.DeleteEvaluationResultsResponse.ReadOnly
      ]
  object DescribeRemediationConfigurations
      extends Effect[
        DescribeRemediationConfigurationsRequest,
        AwsError,
        zio.aws.config.model.DescribeRemediationConfigurationsResponse.ReadOnly
      ]
  object GetComplianceDetailsByResource
      extends Stream[
        GetComplianceDetailsByResourceRequest,
        AwsError,
        zio.aws.config.model.EvaluationResult.ReadOnly
      ]
  object GetComplianceDetailsByResourcePaginated
      extends Effect[
        GetComplianceDetailsByResourceRequest,
        AwsError,
        zio.aws.config.model.GetComplianceDetailsByResourceResponse.ReadOnly
      ]
  object DescribeRemediationExceptions
      extends Stream[
        DescribeRemediationExceptionsRequest,
        AwsError,
        zio.aws.config.model.RemediationException.ReadOnly
      ]
  object DescribeRemediationExceptionsPaginated
      extends Effect[
        DescribeRemediationExceptionsRequest,
        AwsError,
        zio.aws.config.model.DescribeRemediationExceptionsResponse.ReadOnly
      ]
  object ListStoredQueries
      extends Stream[
        ListStoredQueriesRequest,
        AwsError,
        zio.aws.config.model.StoredQueryMetadata.ReadOnly
      ]
  object ListStoredQueriesPaginated
      extends Effect[
        ListStoredQueriesRequest,
        AwsError,
        zio.aws.config.model.ListStoredQueriesResponse.ReadOnly
      ]
  object DeleteResourceConfig
      extends Effect[DeleteResourceConfigRequest, AwsError, Unit]
  object PutRemediationExceptions
      extends Effect[
        PutRemediationExceptionsRequest,
        AwsError,
        zio.aws.config.model.PutRemediationExceptionsResponse.ReadOnly
      ]
  object DeleteConformancePack
      extends Effect[DeleteConformancePackRequest, AwsError, Unit]
  object DeleteRetentionConfiguration
      extends Effect[DeleteRetentionConfigurationRequest, AwsError, Unit]
  object PutExternalEvaluation
      extends Effect[
        PutExternalEvaluationRequest,
        AwsError,
        zio.aws.config.model.PutExternalEvaluationResponse.ReadOnly
      ]
  object GetConformancePackComplianceSummary
      extends Stream[
        GetConformancePackComplianceSummaryRequest,
        AwsError,
        zio.aws.config.model.ConformancePackComplianceSummary.ReadOnly
      ]
  object GetConformancePackComplianceSummaryPaginated
      extends Effect[
        GetConformancePackComplianceSummaryRequest,
        AwsError,
        zio.aws.config.model.GetConformancePackComplianceSummaryResponse.ReadOnly
      ]
  object DeleteConfigRule
      extends Effect[DeleteConfigRuleRequest, AwsError, Unit]
  object DescribeConfigurationRecorders
      extends Effect[
        DescribeConfigurationRecordersRequest,
        AwsError,
        zio.aws.config.model.DescribeConfigurationRecordersResponse.ReadOnly
      ]
  object SelectAggregateResourceConfig
      extends Effect[
        SelectAggregateResourceConfigRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.config.model.SelectAggregateResourceConfigResponse.ReadOnly,
          String
        ]
      ]
  object SelectAggregateResourceConfigPaginated
      extends Effect[
        SelectAggregateResourceConfigRequest,
        AwsError,
        zio.aws.config.model.SelectAggregateResourceConfigResponse.ReadOnly
      ]
  object DescribeOrganizationConformancePacks
      extends Stream[
        DescribeOrganizationConformancePacksRequest,
        AwsError,
        zio.aws.config.model.OrganizationConformancePack.ReadOnly
      ]
  object DescribeOrganizationConformancePacksPaginated
      extends Effect[
        DescribeOrganizationConformancePacksRequest,
        AwsError,
        zio.aws.config.model.DescribeOrganizationConformancePacksResponse.ReadOnly
      ]
  object GetStoredQuery
      extends Effect[
        GetStoredQueryRequest,
        AwsError,
        zio.aws.config.model.GetStoredQueryResponse.ReadOnly
      ]
  object DeletePendingAggregationRequest
      extends Effect[DeletePendingAggregationRequestRequest, AwsError, Unit]
  object GetCustomRulePolicy
      extends Effect[
        GetCustomRulePolicyRequest,
        AwsError,
        zio.aws.config.model.GetCustomRulePolicyResponse.ReadOnly
      ]
  object StartConfigurationRecorder
      extends Effect[StartConfigurationRecorderRequest, AwsError, Unit]
  object PutStoredQuery
      extends Effect[
        PutStoredQueryRequest,
        AwsError,
        zio.aws.config.model.PutStoredQueryResponse.ReadOnly
      ]
  object GetComplianceSummaryByResourceType
      extends Effect[
        GetComplianceSummaryByResourceTypeRequest,
        AwsError,
        zio.aws.config.model.GetComplianceSummaryByResourceTypeResponse.ReadOnly
      ]
  object DescribeConfigRules
      extends Stream[
        DescribeConfigRulesRequest,
        AwsError,
        zio.aws.config.model.ConfigRule.ReadOnly
      ]
  object DescribeConfigRulesPaginated
      extends Effect[
        DescribeConfigRulesRequest,
        AwsError,
        zio.aws.config.model.DescribeConfigRulesResponse.ReadOnly
      ]
  object DescribeConformancePacks
      extends Stream[
        DescribeConformancePacksRequest,
        AwsError,
        zio.aws.config.model.ConformancePackDetail.ReadOnly
      ]
  object DescribeConformancePacksPaginated
      extends Effect[
        DescribeConformancePacksRequest,
        AwsError,
        zio.aws.config.model.DescribeConformancePacksResponse.ReadOnly
      ]
  object GetAggregateResourceConfig
      extends Effect[
        GetAggregateResourceConfigRequest,
        AwsError,
        zio.aws.config.model.GetAggregateResourceConfigResponse.ReadOnly
      ]
  object GetAggregateDiscoveredResourceCounts
      extends Effect[
        GetAggregateDiscoveredResourceCountsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.config.model.GetAggregateDiscoveredResourceCountsResponse.ReadOnly,
          zio.aws.config.model.GroupedResourceCount.ReadOnly
        ]
      ]
  object GetAggregateDiscoveredResourceCountsPaginated
      extends Effect[
        GetAggregateDiscoveredResourceCountsRequest,
        AwsError,
        zio.aws.config.model.GetAggregateDiscoveredResourceCountsResponse.ReadOnly
      ]
  object DescribeConformancePackCompliance
      extends Effect[DescribeConformancePackComplianceRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.config.model.DescribeConformancePackComplianceResponse.ReadOnly,
        zio.aws.config.model.ConformancePackRuleCompliance.ReadOnly
      ]]
  object DescribeConformancePackCompliancePaginated
      extends Effect[
        DescribeConformancePackComplianceRequest,
        AwsError,
        zio.aws.config.model.DescribeConformancePackComplianceResponse.ReadOnly
      ]
  object DescribeComplianceByResource
      extends Stream[
        DescribeComplianceByResourceRequest,
        AwsError,
        zio.aws.config.model.ComplianceByResource.ReadOnly
      ]
  object DescribeComplianceByResourcePaginated
      extends Effect[
        DescribeComplianceByResourceRequest,
        AwsError,
        zio.aws.config.model.DescribeComplianceByResourceResponse.ReadOnly
      ]
  object PutRemediationConfigurations
      extends Effect[
        PutRemediationConfigurationsRequest,
        AwsError,
        zio.aws.config.model.PutRemediationConfigurationsResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object DescribeAggregateComplianceByConformancePacks
      extends Stream[
        DescribeAggregateComplianceByConformancePacksRequest,
        AwsError,
        zio.aws.config.model.AggregateComplianceByConformancePack.ReadOnly
      ]
  object DescribeAggregateComplianceByConformancePacksPaginated
      extends Effect[
        DescribeAggregateComplianceByConformancePacksRequest,
        AwsError,
        zio.aws.config.model.DescribeAggregateComplianceByConformancePacksResponse.ReadOnly
      ]
  object GetResourceConfigHistory
      extends Stream[
        GetResourceConfigHistoryRequest,
        AwsError,
        zio.aws.config.model.ConfigurationItem.ReadOnly
      ]
  object GetResourceConfigHistoryPaginated
      extends Effect[
        GetResourceConfigHistoryRequest,
        AwsError,
        zio.aws.config.model.GetResourceConfigHistoryResponse.ReadOnly
      ]
  object DescribeRetentionConfigurations
      extends Stream[
        DescribeRetentionConfigurationsRequest,
        AwsError,
        zio.aws.config.model.RetentionConfiguration.ReadOnly
      ]
  object DescribeRetentionConfigurationsPaginated
      extends Effect[
        DescribeRetentionConfigurationsRequest,
        AwsError,
        zio.aws.config.model.DescribeRetentionConfigurationsResponse.ReadOnly
      ]
  object PutOrganizationConformancePack
      extends Effect[
        PutOrganizationConformancePackRequest,
        AwsError,
        zio.aws.config.model.PutOrganizationConformancePackResponse.ReadOnly
      ]
  object ListConformancePackComplianceScores
      extends Stream[
        ListConformancePackComplianceScoresRequest,
        AwsError,
        zio.aws.config.model.ConformancePackComplianceScore.ReadOnly
      ]
  object ListConformancePackComplianceScoresPaginated
      extends Effect[
        ListConformancePackComplianceScoresRequest,
        AwsError,
        zio.aws.config.model.ListConformancePackComplianceScoresResponse.ReadOnly
      ]
  object PutOrganizationConfigRule
      extends Effect[
        PutOrganizationConfigRuleRequest,
        AwsError,
        zio.aws.config.model.PutOrganizationConfigRuleResponse.ReadOnly
      ]
  object PutResourceConfig
      extends Effect[PutResourceConfigRequest, AwsError, Unit]
  object DescribeConfigurationAggregatorSourcesStatus
      extends Stream[
        DescribeConfigurationAggregatorSourcesStatusRequest,
        AwsError,
        zio.aws.config.model.AggregatedSourceStatus.ReadOnly
      ]
  object DescribeConfigurationAggregatorSourcesStatusPaginated
      extends Effect[
        DescribeConfigurationAggregatorSourcesStatusRequest,
        AwsError,
        zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusResponse.ReadOnly
      ]
  object DeleteConfigurationAggregator
      extends Effect[DeleteConfigurationAggregatorRequest, AwsError, Unit]
  object DescribeConformancePackStatus
      extends Stream[
        DescribeConformancePackStatusRequest,
        AwsError,
        zio.aws.config.model.ConformancePackStatusDetail.ReadOnly
      ]
  object DescribeConformancePackStatusPaginated
      extends Effect[
        DescribeConformancePackStatusRequest,
        AwsError,
        zio.aws.config.model.DescribeConformancePackStatusResponse.ReadOnly
      ]
  object PutConformancePack
      extends Effect[
        PutConformancePackRequest,
        AwsError,
        zio.aws.config.model.PutConformancePackResponse.ReadOnly
      ]
  object DeleteAggregationAuthorization
      extends Effect[DeleteAggregationAuthorizationRequest, AwsError, Unit]
  object PutEvaluations
      extends Effect[
        PutEvaluationsRequest,
        AwsError,
        zio.aws.config.model.PutEvaluationsResponse.ReadOnly
      ]
  object DeleteDeliveryChannel
      extends Effect[DeleteDeliveryChannelRequest, AwsError, Unit]
  object PutConfigRule extends Effect[PutConfigRuleRequest, AwsError, Unit]
  object ListTagsForResource
      extends Stream[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.config.model.Tag.ReadOnly
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.config.model.ListTagsForResourceResponse.ReadOnly
      ]
  object GetOrganizationConformancePackDetailedStatus
      extends Stream[
        GetOrganizationConformancePackDetailedStatusRequest,
        AwsError,
        zio.aws.config.model.OrganizationConformancePackDetailedStatus.ReadOnly
      ]
  object GetOrganizationConformancePackDetailedStatusPaginated
      extends Effect[
        GetOrganizationConformancePackDetailedStatusRequest,
        AwsError,
        zio.aws.config.model.GetOrganizationConformancePackDetailedStatusResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object DeleteStoredQuery
      extends Effect[DeleteStoredQueryRequest, AwsError, ReadOnly]
  object GetComplianceDetailsByConfigRule
      extends Stream[
        GetComplianceDetailsByConfigRuleRequest,
        AwsError,
        zio.aws.config.model.EvaluationResult.ReadOnly
      ]
  object GetComplianceDetailsByConfigRulePaginated
      extends Effect[
        GetComplianceDetailsByConfigRuleRequest,
        AwsError,
        zio.aws.config.model.GetComplianceDetailsByConfigRuleResponse.ReadOnly
      ]
  object StartRemediationExecution
      extends Effect[
        StartRemediationExecutionRequest,
        AwsError,
        zio.aws.config.model.StartRemediationExecutionResponse.ReadOnly
      ]
  object GetConformancePackComplianceDetails
      extends Effect[
        GetConformancePackComplianceDetailsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.config.model.GetConformancePackComplianceDetailsResponse.ReadOnly,
          zio.aws.config.model.ConformancePackEvaluationResult.ReadOnly
        ]
      ]
  object GetConformancePackComplianceDetailsPaginated
      extends Effect[
        GetConformancePackComplianceDetailsRequest,
        AwsError,
        zio.aws.config.model.GetConformancePackComplianceDetailsResponse.ReadOnly
      ]
  object SelectResourceConfig
      extends Effect[
        SelectResourceConfigRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.config.model.SelectResourceConfigResponse.ReadOnly,
          String
        ]
      ]
  object SelectResourceConfigPaginated
      extends Effect[
        SelectResourceConfigRequest,
        AwsError,
        zio.aws.config.model.SelectResourceConfigResponse.ReadOnly
      ]
  object DescribeRemediationExecutionStatus
      extends Stream[
        DescribeRemediationExecutionStatusRequest,
        AwsError,
        zio.aws.config.model.RemediationExecutionStatus.ReadOnly
      ]
  object DescribeRemediationExecutionStatusPaginated
      extends Effect[
        DescribeRemediationExecutionStatusRequest,
        AwsError,
        zio.aws.config.model.DescribeRemediationExecutionStatusResponse.ReadOnly
      ]
  object DescribeConfigurationRecorderStatus
      extends Effect[
        DescribeConfigurationRecorderStatusRequest,
        AwsError,
        zio.aws.config.model.DescribeConfigurationRecorderStatusResponse.ReadOnly
      ]
  object GetOrganizationCustomRulePolicy
      extends Effect[
        GetOrganizationCustomRulePolicyRequest,
        AwsError,
        zio.aws.config.model.GetOrganizationCustomRulePolicyResponse.ReadOnly
      ]
  object GetAggregateComplianceDetailsByConfigRule
      extends Stream[
        GetAggregateComplianceDetailsByConfigRuleRequest,
        AwsError,
        zio.aws.config.model.AggregateEvaluationResult.ReadOnly
      ]
  object GetAggregateComplianceDetailsByConfigRulePaginated
      extends Effect[
        GetAggregateComplianceDetailsByConfigRuleRequest,
        AwsError,
        zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleResponse.ReadOnly
      ]
  object PutAggregationAuthorization
      extends Effect[
        PutAggregationAuthorizationRequest,
        AwsError,
        zio.aws.config.model.PutAggregationAuthorizationResponse.ReadOnly
      ]
  object GetAggregateConformancePackComplianceSummary
      extends Effect[
        GetAggregateConformancePackComplianceSummaryRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.config.model.GetAggregateConformancePackComplianceSummaryResponse.ReadOnly,
          zio.aws.config.model.AggregateConformancePackComplianceSummary.ReadOnly
        ]
      ]
  object GetAggregateConformancePackComplianceSummaryPaginated
      extends Effect[
        GetAggregateConformancePackComplianceSummaryRequest,
        AwsError,
        zio.aws.config.model.GetAggregateConformancePackComplianceSummaryResponse.ReadOnly
      ]
  object DeleteRemediationConfiguration
      extends Effect[
        DeleteRemediationConfigurationRequest,
        AwsError,
        zio.aws.config.model.DeleteRemediationConfigurationResponse.ReadOnly
      ]
  object DescribeOrganizationConfigRules
      extends Stream[
        DescribeOrganizationConfigRulesRequest,
        AwsError,
        zio.aws.config.model.OrganizationConfigRule.ReadOnly
      ]
  object DescribeOrganizationConfigRulesPaginated
      extends Effect[
        DescribeOrganizationConfigRulesRequest,
        AwsError,
        zio.aws.config.model.DescribeOrganizationConfigRulesResponse.ReadOnly
      ]
  object DeleteConfigurationRecorder
      extends Effect[DeleteConfigurationRecorderRequest, AwsError, Unit]
  object BatchGetResourceConfig
      extends Effect[
        BatchGetResourceConfigRequest,
        AwsError,
        zio.aws.config.model.BatchGetResourceConfigResponse.ReadOnly
      ]
  object BatchGetAggregateResourceConfig
      extends Effect[
        BatchGetAggregateResourceConfigRequest,
        AwsError,
        zio.aws.config.model.BatchGetAggregateResourceConfigResponse.ReadOnly
      ]
  object ListDiscoveredResources
      extends Stream[
        ListDiscoveredResourcesRequest,
        AwsError,
        zio.aws.config.model.ResourceIdentifier.ReadOnly
      ]
  object ListDiscoveredResourcesPaginated
      extends Effect[
        ListDiscoveredResourcesRequest,
        AwsError,
        zio.aws.config.model.ListDiscoveredResourcesResponse.ReadOnly
      ]
  object GetDiscoveredResourceCounts
      extends Effect[
        GetDiscoveredResourceCountsRequest,
        AwsError,
        zio.aws.config.model.GetDiscoveredResourceCountsResponse.ReadOnly
      ]
  object DeliverConfigSnapshot
      extends Effect[
        DeliverConfigSnapshotRequest,
        AwsError,
        zio.aws.config.model.DeliverConfigSnapshotResponse.ReadOnly
      ]
  object PutRetentionConfiguration
      extends Effect[
        PutRetentionConfigurationRequest,
        AwsError,
        zio.aws.config.model.PutRetentionConfigurationResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Config] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Config] { rts =>
        ZIO.succeed {
          new Config {
            val api: ConfigAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Config = this
            def deleteRemediationExceptions(
                request: DeleteRemediationExceptionsRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DeleteRemediationExceptionsResponse.ReadOnly
            ] = proxy(DeleteRemediationExceptions, request)
            def describeComplianceByConfigRule(
                request: DescribeComplianceByConfigRuleRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.ComplianceByConfigRule.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeComplianceByConfigRule, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeComplianceByConfigRulePaginated(
                request: DescribeComplianceByConfigRuleRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeComplianceByConfigRuleResponse.ReadOnly
            ] = proxy(DescribeComplianceByConfigRulePaginated, request)
            def putConfigurationAggregator(
                request: PutConfigurationAggregatorRequest
            ): IO[
              AwsError,
              zio.aws.config.model.PutConfigurationAggregatorResponse.ReadOnly
            ] = proxy(PutConfigurationAggregator, request)
            def getComplianceSummaryByConfigRule(): IO[
              AwsError,
              zio.aws.config.model.GetComplianceSummaryByConfigRuleResponse.ReadOnly
            ] = proxy(GetComplianceSummaryByConfigRule)
            def getAggregateConfigRuleComplianceSummary(
                request: GetAggregateConfigRuleComplianceSummaryRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse.ReadOnly,
              zio.aws.config.model.AggregateComplianceCount.ReadOnly
            ]] = proxy(GetAggregateConfigRuleComplianceSummary, request)
            def getAggregateConfigRuleComplianceSummaryPaginated(
                request: GetAggregateConfigRuleComplianceSummaryRequest
            ): IO[
              AwsError,
              zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse.ReadOnly
            ] = proxy(GetAggregateConfigRuleComplianceSummaryPaginated, request)
            def describeDeliveryChannelStatus(
                request: DescribeDeliveryChannelStatusRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeDeliveryChannelStatusResponse.ReadOnly
            ] = proxy(DescribeDeliveryChannelStatus, request)
            def describeAggregationAuthorizations(
                request: DescribeAggregationAuthorizationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.AggregationAuthorization.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeAggregationAuthorizations, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeAggregationAuthorizationsPaginated(
                request: DescribeAggregationAuthorizationsRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeAggregationAuthorizationsResponse.ReadOnly
            ] = proxy(DescribeAggregationAuthorizationsPaginated, request)
            def getOrganizationConfigRuleDetailedStatus(
                request: GetOrganizationConfigRuleDetailedStatusRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.MemberAccountStatus.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetOrganizationConfigRuleDetailedStatus, request)
                }
                .getOrThrowFiberFailure()
            }
            def getOrganizationConfigRuleDetailedStatusPaginated(
                request: GetOrganizationConfigRuleDetailedStatusRequest
            ): IO[
              AwsError,
              zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusResponse.ReadOnly
            ] = proxy(GetOrganizationConfigRuleDetailedStatusPaginated, request)
            def startConfigRulesEvaluation(
                request: StartConfigRulesEvaluationRequest
            ): IO[
              AwsError,
              zio.aws.config.model.StartConfigRulesEvaluationResponse.ReadOnly
            ] = proxy(StartConfigRulesEvaluation, request)
            def describeOrganizationConfigRuleStatuses(
                request: DescribeOrganizationConfigRuleStatusesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.OrganizationConfigRuleStatus.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeOrganizationConfigRuleStatuses, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeOrganizationConfigRuleStatusesPaginated(
                request: DescribeOrganizationConfigRuleStatusesRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeOrganizationConfigRuleStatusesResponse.ReadOnly
            ] = proxy(DescribeOrganizationConfigRuleStatusesPaginated, request)
            def stopConfigurationRecorder(
                request: StopConfigurationRecorderRequest
            ): IO[AwsError, Unit] = proxy(StopConfigurationRecorder, request)
            def putConfigurationRecorder(
                request: PutConfigurationRecorderRequest
            ): IO[AwsError, Unit] = proxy(PutConfigurationRecorder, request)
            def deleteOrganizationConformancePack(
                request: DeleteOrganizationConformancePackRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteOrganizationConformancePack, request)
            def describeConfigRuleEvaluationStatus(
                request: DescribeConfigRuleEvaluationStatusRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.ConfigRuleEvaluationStatus.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeConfigRuleEvaluationStatus, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeConfigRuleEvaluationStatusPaginated(
                request: DescribeConfigRuleEvaluationStatusRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeConfigRuleEvaluationStatusResponse.ReadOnly
            ] = proxy(DescribeConfigRuleEvaluationStatusPaginated, request)
            def describeOrganizationConformancePackStatuses(
                request: DescribeOrganizationConformancePackStatusesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.OrganizationConformancePackStatus.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeOrganizationConformancePackStatuses, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeOrganizationConformancePackStatusesPaginated(
                request: DescribeOrganizationConformancePackStatusesRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeOrganizationConformancePackStatusesResponse.ReadOnly
            ] = proxy(
              DescribeOrganizationConformancePackStatusesPaginated,
              request
            )
            def describeConfigurationAggregators(
                request: DescribeConfigurationAggregatorsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.ConfigurationAggregator.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeConfigurationAggregators, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeConfigurationAggregatorsPaginated(
                request: DescribeConfigurationAggregatorsRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeConfigurationAggregatorsResponse.ReadOnly
            ] = proxy(DescribeConfigurationAggregatorsPaginated, request)
            def describeDeliveryChannels(
                request: DescribeDeliveryChannelsRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeDeliveryChannelsResponse.ReadOnly
            ] = proxy(DescribeDeliveryChannels, request)
            def deleteOrganizationConfigRule(
                request: DeleteOrganizationConfigRuleRequest
            ): IO[AwsError, Unit] = proxy(DeleteOrganizationConfigRule, request)
            def putDeliveryChannel(
                request: PutDeliveryChannelRequest
            ): IO[AwsError, Unit] = proxy(PutDeliveryChannel, request)
            def listAggregateDiscoveredResources(
                request: ListAggregateDiscoveredResourcesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.AggregateResourceIdentifier.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAggregateDiscoveredResources, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAggregateDiscoveredResourcesPaginated(
                request: ListAggregateDiscoveredResourcesRequest
            ): IO[
              AwsError,
              zio.aws.config.model.ListAggregateDiscoveredResourcesResponse.ReadOnly
            ] = proxy(ListAggregateDiscoveredResourcesPaginated, request)
            def describePendingAggregationRequests(
                request: DescribePendingAggregationRequestsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.PendingAggregationRequest.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribePendingAggregationRequests, request)
                }
                .getOrThrowFiberFailure()
            }
            def describePendingAggregationRequestsPaginated(
                request: DescribePendingAggregationRequestsRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribePendingAggregationRequestsResponse.ReadOnly
            ] = proxy(DescribePendingAggregationRequestsPaginated, request)
            def describeAggregateComplianceByConfigRules(
                request: DescribeAggregateComplianceByConfigRulesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.AggregateComplianceByConfigRule.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeAggregateComplianceByConfigRules, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeAggregateComplianceByConfigRulesPaginated(
                request: DescribeAggregateComplianceByConfigRulesRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeAggregateComplianceByConfigRulesResponse.ReadOnly
            ] =
              proxy(DescribeAggregateComplianceByConfigRulesPaginated, request)
            def deleteEvaluationResults(
                request: DeleteEvaluationResultsRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DeleteEvaluationResultsResponse.ReadOnly
            ] = proxy(DeleteEvaluationResults, request)
            def describeRemediationConfigurations(
                request: DescribeRemediationConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeRemediationConfigurationsResponse.ReadOnly
            ] = proxy(DescribeRemediationConfigurations, request)
            def getComplianceDetailsByResource(
                request: GetComplianceDetailsByResourceRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.EvaluationResult.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetComplianceDetailsByResource, request)
                }
                .getOrThrowFiberFailure()
            }
            def getComplianceDetailsByResourcePaginated(
                request: GetComplianceDetailsByResourceRequest
            ): IO[
              AwsError,
              zio.aws.config.model.GetComplianceDetailsByResourceResponse.ReadOnly
            ] = proxy(GetComplianceDetailsByResourcePaginated, request)
            def describeRemediationExceptions(
                request: DescribeRemediationExceptionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.RemediationException.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeRemediationExceptions, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeRemediationExceptionsPaginated(
                request: DescribeRemediationExceptionsRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeRemediationExceptionsResponse.ReadOnly
            ] = proxy(DescribeRemediationExceptionsPaginated, request)
            def listStoredQueries(request: ListStoredQueriesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.StoredQueryMetadata.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListStoredQueries, request)
                }
                .getOrThrowFiberFailure()
            }
            def listStoredQueriesPaginated(
                request: ListStoredQueriesRequest
            ): IO[
              AwsError,
              zio.aws.config.model.ListStoredQueriesResponse.ReadOnly
            ] = proxy(ListStoredQueriesPaginated, request)
            def deleteResourceConfig(
                request: DeleteResourceConfigRequest
            ): IO[AwsError, Unit] = proxy(DeleteResourceConfig, request)
            def putRemediationExceptions(
                request: PutRemediationExceptionsRequest
            ): IO[
              AwsError,
              zio.aws.config.model.PutRemediationExceptionsResponse.ReadOnly
            ] = proxy(PutRemediationExceptions, request)
            def deleteConformancePack(
                request: DeleteConformancePackRequest
            ): IO[AwsError, Unit] = proxy(DeleteConformancePack, request)
            def deleteRetentionConfiguration(
                request: DeleteRetentionConfigurationRequest
            ): IO[AwsError, Unit] = proxy(DeleteRetentionConfiguration, request)
            def putExternalEvaluation(
                request: PutExternalEvaluationRequest
            ): IO[
              AwsError,
              zio.aws.config.model.PutExternalEvaluationResponse.ReadOnly
            ] = proxy(PutExternalEvaluation, request)
            def getConformancePackComplianceSummary(
                request: GetConformancePackComplianceSummaryRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.ConformancePackComplianceSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetConformancePackComplianceSummary, request)
                }
                .getOrThrowFiberFailure()
            }
            def getConformancePackComplianceSummaryPaginated(
                request: GetConformancePackComplianceSummaryRequest
            ): IO[
              AwsError,
              zio.aws.config.model.GetConformancePackComplianceSummaryResponse.ReadOnly
            ] = proxy(GetConformancePackComplianceSummaryPaginated, request)
            def deleteConfigRule(
                request: DeleteConfigRuleRequest
            ): IO[AwsError, Unit] = proxy(DeleteConfigRule, request)
            def describeConfigurationRecorders(
                request: DescribeConfigurationRecordersRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeConfigurationRecordersResponse.ReadOnly
            ] = proxy(DescribeConfigurationRecorders, request)
            def selectAggregateResourceConfig(
                request: SelectAggregateResourceConfigRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.config.model.SelectAggregateResourceConfigResponse.ReadOnly,
              String
            ]] = proxy(SelectAggregateResourceConfig, request)
            def selectAggregateResourceConfigPaginated(
                request: SelectAggregateResourceConfigRequest
            ): IO[
              AwsError,
              zio.aws.config.model.SelectAggregateResourceConfigResponse.ReadOnly
            ] = proxy(SelectAggregateResourceConfigPaginated, request)
            def describeOrganizationConformancePacks(
                request: DescribeOrganizationConformancePacksRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.OrganizationConformancePack.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeOrganizationConformancePacks, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeOrganizationConformancePacksPaginated(
                request: DescribeOrganizationConformancePacksRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeOrganizationConformancePacksResponse.ReadOnly
            ] = proxy(DescribeOrganizationConformancePacksPaginated, request)
            def getStoredQuery(request: GetStoredQueryRequest): IO[
              AwsError,
              zio.aws.config.model.GetStoredQueryResponse.ReadOnly
            ] = proxy(GetStoredQuery, request)
            def deletePendingAggregationRequest(
                request: DeletePendingAggregationRequestRequest
            ): IO[AwsError, Unit] =
              proxy(DeletePendingAggregationRequest, request)
            def getCustomRulePolicy(request: GetCustomRulePolicyRequest): IO[
              AwsError,
              zio.aws.config.model.GetCustomRulePolicyResponse.ReadOnly
            ] = proxy(GetCustomRulePolicy, request)
            def startConfigurationRecorder(
                request: StartConfigurationRecorderRequest
            ): IO[AwsError, Unit] = proxy(StartConfigurationRecorder, request)
            def putStoredQuery(request: PutStoredQueryRequest): IO[
              AwsError,
              zio.aws.config.model.PutStoredQueryResponse.ReadOnly
            ] = proxy(PutStoredQuery, request)
            def getComplianceSummaryByResourceType(
                request: GetComplianceSummaryByResourceTypeRequest
            ): IO[
              AwsError,
              zio.aws.config.model.GetComplianceSummaryByResourceTypeResponse.ReadOnly
            ] = proxy(GetComplianceSummaryByResourceType, request)
            def describeConfigRules(
                request: DescribeConfigRulesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.ConfigRule.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeConfigRules, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeConfigRulesPaginated(
                request: DescribeConfigRulesRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeConfigRulesResponse.ReadOnly
            ] = proxy(DescribeConfigRulesPaginated, request)
            def describeConformancePacks(
                request: DescribeConformancePacksRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.ConformancePackDetail.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeConformancePacks, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeConformancePacksPaginated(
                request: DescribeConformancePacksRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeConformancePacksResponse.ReadOnly
            ] = proxy(DescribeConformancePacksPaginated, request)
            def getAggregateResourceConfig(
                request: GetAggregateResourceConfigRequest
            ): IO[
              AwsError,
              zio.aws.config.model.GetAggregateResourceConfigResponse.ReadOnly
            ] = proxy(GetAggregateResourceConfig, request)
            def getAggregateDiscoveredResourceCounts(
                request: GetAggregateDiscoveredResourceCountsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.config.model.GetAggregateDiscoveredResourceCountsResponse.ReadOnly,
              zio.aws.config.model.GroupedResourceCount.ReadOnly
            ]] = proxy(GetAggregateDiscoveredResourceCounts, request)
            def getAggregateDiscoveredResourceCountsPaginated(
                request: GetAggregateDiscoveredResourceCountsRequest
            ): IO[
              AwsError,
              zio.aws.config.model.GetAggregateDiscoveredResourceCountsResponse.ReadOnly
            ] = proxy(GetAggregateDiscoveredResourceCountsPaginated, request)
            def describeConformancePackCompliance(
                request: DescribeConformancePackComplianceRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.config.model.DescribeConformancePackComplianceResponse.ReadOnly,
              zio.aws.config.model.ConformancePackRuleCompliance.ReadOnly
            ]] = proxy(DescribeConformancePackCompliance, request)
            def describeConformancePackCompliancePaginated(
                request: DescribeConformancePackComplianceRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeConformancePackComplianceResponse.ReadOnly
            ] = proxy(DescribeConformancePackCompliancePaginated, request)
            def describeComplianceByResource(
                request: DescribeComplianceByResourceRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.ComplianceByResource.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeComplianceByResource, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeComplianceByResourcePaginated(
                request: DescribeComplianceByResourceRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeComplianceByResourceResponse.ReadOnly
            ] = proxy(DescribeComplianceByResourcePaginated, request)
            def putRemediationConfigurations(
                request: PutRemediationConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.config.model.PutRemediationConfigurationsResponse.ReadOnly
            ] = proxy(PutRemediationConfigurations, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, Unit] = proxy(UntagResource, request)
            def describeAggregateComplianceByConformancePacks(
                request: DescribeAggregateComplianceByConformancePacksRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.AggregateComplianceByConformancePack.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeAggregateComplianceByConformancePacks, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeAggregateComplianceByConformancePacksPaginated(
                request: DescribeAggregateComplianceByConformancePacksRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeAggregateComplianceByConformancePacksResponse.ReadOnly
            ] = proxy(
              DescribeAggregateComplianceByConformancePacksPaginated,
              request
            )
            def getResourceConfigHistory(
                request: GetResourceConfigHistoryRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.ConfigurationItem.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetResourceConfigHistory, request)
                }
                .getOrThrowFiberFailure()
            }
            def getResourceConfigHistoryPaginated(
                request: GetResourceConfigHistoryRequest
            ): IO[
              AwsError,
              zio.aws.config.model.GetResourceConfigHistoryResponse.ReadOnly
            ] = proxy(GetResourceConfigHistoryPaginated, request)
            def describeRetentionConfigurations(
                request: DescribeRetentionConfigurationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.RetentionConfiguration.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeRetentionConfigurations, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeRetentionConfigurationsPaginated(
                request: DescribeRetentionConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeRetentionConfigurationsResponse.ReadOnly
            ] = proxy(DescribeRetentionConfigurationsPaginated, request)
            def putOrganizationConformancePack(
                request: PutOrganizationConformancePackRequest
            ): IO[
              AwsError,
              zio.aws.config.model.PutOrganizationConformancePackResponse.ReadOnly
            ] = proxy(PutOrganizationConformancePack, request)
            def listConformancePackComplianceScores(
                request: ListConformancePackComplianceScoresRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.ConformancePackComplianceScore.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListConformancePackComplianceScores, request)
                }
                .getOrThrowFiberFailure()
            }
            def listConformancePackComplianceScoresPaginated(
                request: ListConformancePackComplianceScoresRequest
            ): IO[
              AwsError,
              zio.aws.config.model.ListConformancePackComplianceScoresResponse.ReadOnly
            ] = proxy(ListConformancePackComplianceScoresPaginated, request)
            def putOrganizationConfigRule(
                request: PutOrganizationConfigRuleRequest
            ): IO[
              AwsError,
              zio.aws.config.model.PutOrganizationConfigRuleResponse.ReadOnly
            ] = proxy(PutOrganizationConfigRule, request)
            def putResourceConfig(
                request: PutResourceConfigRequest
            ): IO[AwsError, Unit] = proxy(PutResourceConfig, request)
            def describeConfigurationAggregatorSourcesStatus(
                request: DescribeConfigurationAggregatorSourcesStatusRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.AggregatedSourceStatus.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeConfigurationAggregatorSourcesStatus, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeConfigurationAggregatorSourcesStatusPaginated(
                request: DescribeConfigurationAggregatorSourcesStatusRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeConfigurationAggregatorSourcesStatusResponse.ReadOnly
            ] = proxy(
              DescribeConfigurationAggregatorSourcesStatusPaginated,
              request
            )
            def deleteConfigurationAggregator(
                request: DeleteConfigurationAggregatorRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteConfigurationAggregator, request)
            def describeConformancePackStatus(
                request: DescribeConformancePackStatusRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.ConformancePackStatusDetail.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeConformancePackStatus, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeConformancePackStatusPaginated(
                request: DescribeConformancePackStatusRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeConformancePackStatusResponse.ReadOnly
            ] = proxy(DescribeConformancePackStatusPaginated, request)
            def putConformancePack(request: PutConformancePackRequest): IO[
              AwsError,
              zio.aws.config.model.PutConformancePackResponse.ReadOnly
            ] = proxy(PutConformancePack, request)
            def deleteAggregationAuthorization(
                request: DeleteAggregationAuthorizationRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteAggregationAuthorization, request)
            def putEvaluations(request: PutEvaluationsRequest): IO[
              AwsError,
              zio.aws.config.model.PutEvaluationsResponse.ReadOnly
            ] = proxy(PutEvaluations, request)
            def deleteDeliveryChannel(
                request: DeleteDeliveryChannelRequest
            ): IO[AwsError, Unit] = proxy(DeleteDeliveryChannel, request)
            def putConfigRule(
                request: PutConfigRuleRequest
            ): IO[AwsError, Unit] = proxy(PutConfigRule, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): ZStream[Any, AwsError, zio.aws.config.model.Tag.ReadOnly] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListTagsForResource, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listTagsForResourcePaginated(
                request: ListTagsForResourceRequest
            ): IO[
              AwsError,
              zio.aws.config.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResourcePaginated, request)
            def getOrganizationConformancePackDetailedStatus(
                request: GetOrganizationConformancePackDetailedStatusRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.OrganizationConformancePackDetailedStatus.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetOrganizationConformancePackDetailedStatus, request)
                }
                .getOrThrowFiberFailure()
            }
            def getOrganizationConformancePackDetailedStatusPaginated(
                request: GetOrganizationConformancePackDetailedStatusRequest
            ): IO[
              AwsError,
              zio.aws.config.model.GetOrganizationConformancePackDetailedStatusResponse.ReadOnly
            ] = proxy(
              GetOrganizationConformancePackDetailedStatusPaginated,
              request
            )
            def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
              proxy(TagResource, request)
            def deleteStoredQuery(
                request: DeleteStoredQueryRequest
            ): IO[AwsError, ReadOnly] = proxy(DeleteStoredQuery, request)
            def getComplianceDetailsByConfigRule(
                request: GetComplianceDetailsByConfigRuleRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.EvaluationResult.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetComplianceDetailsByConfigRule, request)
                }
                .getOrThrowFiberFailure()
            }
            def getComplianceDetailsByConfigRulePaginated(
                request: GetComplianceDetailsByConfigRuleRequest
            ): IO[
              AwsError,
              zio.aws.config.model.GetComplianceDetailsByConfigRuleResponse.ReadOnly
            ] = proxy(GetComplianceDetailsByConfigRulePaginated, request)
            def startRemediationExecution(
                request: StartRemediationExecutionRequest
            ): IO[
              AwsError,
              zio.aws.config.model.StartRemediationExecutionResponse.ReadOnly
            ] = proxy(StartRemediationExecution, request)
            def getConformancePackComplianceDetails(
                request: GetConformancePackComplianceDetailsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.config.model.GetConformancePackComplianceDetailsResponse.ReadOnly,
              zio.aws.config.model.ConformancePackEvaluationResult.ReadOnly
            ]] = proxy(GetConformancePackComplianceDetails, request)
            def getConformancePackComplianceDetailsPaginated(
                request: GetConformancePackComplianceDetailsRequest
            ): IO[
              AwsError,
              zio.aws.config.model.GetConformancePackComplianceDetailsResponse.ReadOnly
            ] = proxy(GetConformancePackComplianceDetailsPaginated, request)
            def selectResourceConfig(
                request: SelectResourceConfigRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.config.model.SelectResourceConfigResponse.ReadOnly,
              String
            ]] = proxy(SelectResourceConfig, request)
            def selectResourceConfigPaginated(
                request: SelectResourceConfigRequest
            ): IO[
              AwsError,
              zio.aws.config.model.SelectResourceConfigResponse.ReadOnly
            ] = proxy(SelectResourceConfigPaginated, request)
            def describeRemediationExecutionStatus(
                request: DescribeRemediationExecutionStatusRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.RemediationExecutionStatus.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeRemediationExecutionStatus, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeRemediationExecutionStatusPaginated(
                request: DescribeRemediationExecutionStatusRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeRemediationExecutionStatusResponse.ReadOnly
            ] = proxy(DescribeRemediationExecutionStatusPaginated, request)
            def describeConfigurationRecorderStatus(
                request: DescribeConfigurationRecorderStatusRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeConfigurationRecorderStatusResponse.ReadOnly
            ] = proxy(DescribeConfigurationRecorderStatus, request)
            def getOrganizationCustomRulePolicy(
                request: GetOrganizationCustomRulePolicyRequest
            ): IO[
              AwsError,
              zio.aws.config.model.GetOrganizationCustomRulePolicyResponse.ReadOnly
            ] = proxy(GetOrganizationCustomRulePolicy, request)
            def getAggregateComplianceDetailsByConfigRule(
                request: GetAggregateComplianceDetailsByConfigRuleRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.AggregateEvaluationResult.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetAggregateComplianceDetailsByConfigRule, request)
                }
                .getOrThrowFiberFailure()
            }
            def getAggregateComplianceDetailsByConfigRulePaginated(
                request: GetAggregateComplianceDetailsByConfigRuleRequest
            ): IO[
              AwsError,
              zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleResponse.ReadOnly
            ] =
              proxy(GetAggregateComplianceDetailsByConfigRulePaginated, request)
            def putAggregationAuthorization(
                request: PutAggregationAuthorizationRequest
            ): IO[
              AwsError,
              zio.aws.config.model.PutAggregationAuthorizationResponse.ReadOnly
            ] = proxy(PutAggregationAuthorization, request)
            def getAggregateConformancePackComplianceSummary(
                request: GetAggregateConformancePackComplianceSummaryRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.config.model.GetAggregateConformancePackComplianceSummaryResponse.ReadOnly,
              zio.aws.config.model.AggregateConformancePackComplianceSummary.ReadOnly
            ]] = proxy(GetAggregateConformancePackComplianceSummary, request)
            def getAggregateConformancePackComplianceSummaryPaginated(
                request: GetAggregateConformancePackComplianceSummaryRequest
            ): IO[
              AwsError,
              zio.aws.config.model.GetAggregateConformancePackComplianceSummaryResponse.ReadOnly
            ] = proxy(
              GetAggregateConformancePackComplianceSummaryPaginated,
              request
            )
            def deleteRemediationConfiguration(
                request: DeleteRemediationConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DeleteRemediationConfigurationResponse.ReadOnly
            ] = proxy(DeleteRemediationConfiguration, request)
            def describeOrganizationConfigRules(
                request: DescribeOrganizationConfigRulesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.OrganizationConfigRule.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeOrganizationConfigRules, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeOrganizationConfigRulesPaginated(
                request: DescribeOrganizationConfigRulesRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DescribeOrganizationConfigRulesResponse.ReadOnly
            ] = proxy(DescribeOrganizationConfigRulesPaginated, request)
            def deleteConfigurationRecorder(
                request: DeleteConfigurationRecorderRequest
            ): IO[AwsError, Unit] = proxy(DeleteConfigurationRecorder, request)
            def batchGetResourceConfig(
                request: BatchGetResourceConfigRequest
            ): IO[
              AwsError,
              zio.aws.config.model.BatchGetResourceConfigResponse.ReadOnly
            ] = proxy(BatchGetResourceConfig, request)
            def batchGetAggregateResourceConfig(
                request: BatchGetAggregateResourceConfigRequest
            ): IO[
              AwsError,
              zio.aws.config.model.BatchGetAggregateResourceConfigResponse.ReadOnly
            ] = proxy(BatchGetAggregateResourceConfig, request)
            def listDiscoveredResources(
                request: ListDiscoveredResourcesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.config.model.ResourceIdentifier.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDiscoveredResources, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDiscoveredResourcesPaginated(
                request: ListDiscoveredResourcesRequest
            ): IO[
              AwsError,
              zio.aws.config.model.ListDiscoveredResourcesResponse.ReadOnly
            ] = proxy(ListDiscoveredResourcesPaginated, request)
            def getDiscoveredResourceCounts(
                request: GetDiscoveredResourceCountsRequest
            ): IO[
              AwsError,
              zio.aws.config.model.GetDiscoveredResourceCountsResponse.ReadOnly
            ] = proxy(GetDiscoveredResourceCounts, request)
            def deliverConfigSnapshot(
                request: DeliverConfigSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.config.model.DeliverConfigSnapshotResponse.ReadOnly
            ] = proxy(DeliverConfigSnapshot, request)
            def putRetentionConfiguration(
                request: PutRetentionConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.config.model.PutRetentionConfigurationResponse.ReadOnly
            ] = proxy(PutRetentionConfiguration, request)
          }
        }
      }
    }
  }
}
