package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SourceDetail(
    eventSource: Optional[zio.aws.config.model.EventSource] = Optional.Absent,
    messageType: Optional[zio.aws.config.model.MessageType] = Optional.Absent,
    maximumExecutionFrequency: Optional[
      zio.aws.config.model.MaximumExecutionFrequency
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.SourceDetail = {
    import SourceDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.SourceDetail
      .builder()
      .optionallyWith(eventSource.map(value => value.unwrap))(_.eventSource)
      .optionallyWith(messageType.map(value => value.unwrap))(_.messageType)
      .optionallyWith(maximumExecutionFrequency.map(value => value.unwrap))(
        _.maximumExecutionFrequency
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.SourceDetail.ReadOnly =
    zio.aws.config.model.SourceDetail.wrap(buildAwsValue())
}
object SourceDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.SourceDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.SourceDetail =
      zio.aws.config.model.SourceDetail(
        eventSource.map(value => value),
        messageType.map(value => value),
        maximumExecutionFrequency.map(value => value)
      )
    def eventSource: Optional[zio.aws.config.model.EventSource]
    def messageType: Optional[zio.aws.config.model.MessageType]
    def maximumExecutionFrequency
        : Optional[zio.aws.config.model.MaximumExecutionFrequency]
    def getEventSource: ZIO[Any, AwsError, zio.aws.config.model.EventSource] =
      AwsError.unwrapOptionField("eventSource", eventSource)
    def getMessageType: ZIO[Any, AwsError, zio.aws.config.model.MessageType] =
      AwsError.unwrapOptionField("messageType", messageType)
    def getMaximumExecutionFrequency
        : ZIO[Any, AwsError, zio.aws.config.model.MaximumExecutionFrequency] =
      AwsError.unwrapOptionField(
        "maximumExecutionFrequency",
        maximumExecutionFrequency
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.SourceDetail
  ) extends zio.aws.config.model.SourceDetail.ReadOnly {
    override val eventSource: Optional[zio.aws.config.model.EventSource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventSource())
        .map(value => zio.aws.config.model.EventSource.wrap(value))
    override val messageType: Optional[zio.aws.config.model.MessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageType())
        .map(value => zio.aws.config.model.MessageType.wrap(value))
    override val maximumExecutionFrequency
        : Optional[zio.aws.config.model.MaximumExecutionFrequency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumExecutionFrequency())
        .map(value =>
          zio.aws.config.model.MaximumExecutionFrequency.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.SourceDetail
  ): zio.aws.config.model.SourceDetail.ReadOnly = new Wrapper(impl)
}
