package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  StringWithCharLimit1024,
  StringWithCharLimit256
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RemediationExceptionResourceKey(
    resourceType: Optional[StringWithCharLimit256] = Optional.Absent,
    resourceId: Optional[StringWithCharLimit1024] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.RemediationExceptionResourceKey = {
    import RemediationExceptionResourceKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.RemediationExceptionResourceKey
      .builder()
      .optionallyWith(
        resourceType.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        resourceId.map(value =>
          StringWithCharLimit1024.unwrap(value): java.lang.String
        )
      )(_.resourceId)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.RemediationExceptionResourceKey.ReadOnly =
    zio.aws.config.model.RemediationExceptionResourceKey.wrap(buildAwsValue())
}
object RemediationExceptionResourceKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.RemediationExceptionResourceKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.RemediationExceptionResourceKey =
      zio.aws.config.model.RemediationExceptionResourceKey(
        resourceType.map(value => value),
        resourceId.map(value => value)
      )
    def resourceType: Optional[StringWithCharLimit256]
    def resourceId: Optional[StringWithCharLimit1024]
    def getResourceType: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, StringWithCharLimit1024] =
      AwsError.unwrapOptionField("resourceId", resourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.RemediationExceptionResourceKey
  ) extends zio.aws.config.model.RemediationExceptionResourceKey.ReadOnly {
    override val resourceType: Optional[StringWithCharLimit256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit256(value)
        )
    override val resourceId: Optional[StringWithCharLimit1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceId())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit1024(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.RemediationExceptionResourceKey
  ): zio.aws.config.model.RemediationExceptionResourceKey.ReadOnly =
    new Wrapper(impl)
}
