package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.RecorderName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeConfigurationRecordersRequest(
    configurationRecorderNames: Optional[Iterable[RecorderName]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersRequest = {
    import DescribeConfigurationRecordersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersRequest
      .builder()
      .optionallyWith(
        configurationRecorderNames.map(value =>
          value.map { item =>
            RecorderName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.configurationRecorderNames)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeConfigurationRecordersRequest.ReadOnly =
    zio.aws.config.model.DescribeConfigurationRecordersRequest
      .wrap(buildAwsValue())
}
object DescribeConfigurationRecordersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DescribeConfigurationRecordersRequest =
      zio.aws.config.model.DescribeConfigurationRecordersRequest(
        configurationRecorderNames.map(value => value)
      )
    def configurationRecorderNames: Optional[List[RecorderName]]
    def getConfigurationRecorderNames: ZIO[Any, AwsError, List[RecorderName]] =
      AwsError.unwrapOptionField(
        "configurationRecorderNames",
        configurationRecorderNames
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersRequest
  ) extends zio.aws.config.model.DescribeConfigurationRecordersRequest.ReadOnly {
    override val configurationRecorderNames: Optional[List[RecorderName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationRecorderNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.primitives.RecorderName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersRequest
  ): zio.aws.config.model.DescribeConfigurationRecordersRequest.ReadOnly =
    new Wrapper(impl)
}
