package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{Annotation, Date}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ConformancePackEvaluationResult(
    complianceType: zio.aws.config.model.ConformancePackComplianceType,
    evaluationResultIdentifier: zio.aws.config.model.EvaluationResultIdentifier,
    configRuleInvokedTime: Date,
    resultRecordedTime: Date,
    annotation: Optional[Annotation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConformancePackEvaluationResult = {
    import ConformancePackEvaluationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConformancePackEvaluationResult
      .builder()
      .complianceType(complianceType.unwrap)
      .evaluationResultIdentifier(evaluationResultIdentifier.buildAwsValue())
      .configRuleInvokedTime(Date.unwrap(configRuleInvokedTime): Instant)
      .resultRecordedTime(Date.unwrap(resultRecordedTime): Instant)
      .optionallyWith(
        annotation.map(value => Annotation.unwrap(value): java.lang.String)
      )(_.annotation)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.ConformancePackEvaluationResult.ReadOnly =
    zio.aws.config.model.ConformancePackEvaluationResult.wrap(buildAwsValue())
}
object ConformancePackEvaluationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConformancePackEvaluationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConformancePackEvaluationResult =
      zio.aws.config.model.ConformancePackEvaluationResult(
        complianceType,
        evaluationResultIdentifier.asEditable,
        configRuleInvokedTime,
        resultRecordedTime,
        annotation.map(value => value)
      )
    def complianceType: zio.aws.config.model.ConformancePackComplianceType
    def evaluationResultIdentifier
        : zio.aws.config.model.EvaluationResultIdentifier.ReadOnly
    def configRuleInvokedTime: Date
    def resultRecordedTime: Date
    def annotation: Optional[Annotation]
    def getComplianceType: ZIO[
      Any,
      Nothing,
      zio.aws.config.model.ConformancePackComplianceType
    ] = ZIO.succeed(complianceType)
    def getEvaluationResultIdentifier: ZIO[
      Any,
      Nothing,
      zio.aws.config.model.EvaluationResultIdentifier.ReadOnly
    ] = ZIO.succeed(evaluationResultIdentifier)
    def getConfigRuleInvokedTime: ZIO[Any, Nothing, Date] =
      ZIO.succeed(configRuleInvokedTime)
    def getResultRecordedTime: ZIO[Any, Nothing, Date] =
      ZIO.succeed(resultRecordedTime)
    def getAnnotation: ZIO[Any, AwsError, Annotation] =
      AwsError.unwrapOptionField("annotation", annotation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConformancePackEvaluationResult
  ) extends zio.aws.config.model.ConformancePackEvaluationResult.ReadOnly {
    override val complianceType
        : zio.aws.config.model.ConformancePackComplianceType =
      zio.aws.config.model.ConformancePackComplianceType
        .wrap(impl.complianceType())
    override val evaluationResultIdentifier
        : zio.aws.config.model.EvaluationResultIdentifier.ReadOnly =
      zio.aws.config.model.EvaluationResultIdentifier
        .wrap(impl.evaluationResultIdentifier())
    override val configRuleInvokedTime: Date =
      zio.aws.config.model.primitives.Date(impl.configRuleInvokedTime())
    override val resultRecordedTime: Date =
      zio.aws.config.model.primitives.Date(impl.resultRecordedTime())
    override val annotation: Optional[Annotation] = zio.aws.core.internal
      .optionalFromNullable(impl.annotation())
      .map(value => zio.aws.config.model.primitives.Annotation(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConformancePackEvaluationResult
  ): zio.aws.config.model.ConformancePackEvaluationResult.ReadOnly =
    new Wrapper(impl)
}
