package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait ChronologicalOrder {
  def unwrap: software.amazon.awssdk.services.config.model.ChronologicalOrder
}
object ChronologicalOrder {
  def wrap(
      value: software.amazon.awssdk.services.config.model.ChronologicalOrder
  ): zio.aws.config.model.ChronologicalOrder = value match {
    case software.amazon.awssdk.services.config.model.ChronologicalOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.ChronologicalOrder.REVERSE =>
      val r = Reverse
      r
    case software.amazon.awssdk.services.config.model.ChronologicalOrder.FORWARD =>
      val r = Forward
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.config.model.ChronologicalOrder {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ChronologicalOrder =
      software.amazon.awssdk.services.config.model.ChronologicalOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object Reverse extends zio.aws.config.model.ChronologicalOrder {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ChronologicalOrder =
      software.amazon.awssdk.services.config.model.ChronologicalOrder.REVERSE
  }
  case object Forward extends zio.aws.config.model.ChronologicalOrder {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ChronologicalOrder =
      software.amazon.awssdk.services.config.model.ChronologicalOrder.FORWARD
  }
}
