package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait ConfigurationItemStatus {
  def unwrap
      : software.amazon.awssdk.services.config.model.ConfigurationItemStatus
}
object ConfigurationItemStatus {
  def wrap(
      value: software.amazon.awssdk.services.config.model.ConfigurationItemStatus
  ): zio.aws.config.model.ConfigurationItemStatus = value match {
    case software.amazon.awssdk.services.config.model.ConfigurationItemStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.ConfigurationItemStatus.OK =>
      val r = OK
      r
    case software.amazon.awssdk.services.config.model.ConfigurationItemStatus.RESOURCE_DISCOVERED =>
      val r = ResourceDiscovered
      r
    case software.amazon.awssdk.services.config.model.ConfigurationItemStatus.RESOURCE_NOT_RECORDED =>
      val r = ResourceNotRecorded
      r
    case software.amazon.awssdk.services.config.model.ConfigurationItemStatus.RESOURCE_DELETED =>
      val r = ResourceDeleted
      r
    case software.amazon.awssdk.services.config.model.ConfigurationItemStatus.RESOURCE_DELETED_NOT_RECORDED =>
      val r = ResourceDeletedNotRecorded
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.config.model.ConfigurationItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ConfigurationItemStatus =
      software.amazon.awssdk.services.config.model.ConfigurationItemStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object OK extends zio.aws.config.model.ConfigurationItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ConfigurationItemStatus =
      software.amazon.awssdk.services.config.model.ConfigurationItemStatus.OK
  }
  case object ResourceDiscovered
      extends zio.aws.config.model.ConfigurationItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ConfigurationItemStatus =
      software.amazon.awssdk.services.config.model.ConfigurationItemStatus.RESOURCE_DISCOVERED
  }
  case object ResourceNotRecorded
      extends zio.aws.config.model.ConfigurationItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ConfigurationItemStatus =
      software.amazon.awssdk.services.config.model.ConfigurationItemStatus.RESOURCE_NOT_RECORDED
  }
  case object ResourceDeleted
      extends zio.aws.config.model.ConfigurationItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ConfigurationItemStatus =
      software.amazon.awssdk.services.config.model.ConfigurationItemStatus.RESOURCE_DELETED
  }
  case object ResourceDeletedNotRecorded
      extends zio.aws.config.model.ConfigurationItemStatus {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ConfigurationItemStatus =
      software.amazon.awssdk.services.config.model.ConfigurationItemStatus.RESOURCE_DELETED_NOT_RECORDED
  }
}
