package zio.aws.config.model
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{
  AutoRemediationAttemptSeconds,
  StringWithCharLimit1024,
  StringWithCharLimit256,
  ConfigRuleName,
  AutoRemediationAttempts
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RemediationConfiguration(
    configRuleName: ConfigRuleName,
    targetType: zio.aws.config.model.RemediationTargetType,
    targetId: StringWithCharLimit256,
    targetVersion: Optional[String] = Optional.Absent,
    parameters: Optional[Map[
      StringWithCharLimit256,
      zio.aws.config.model.RemediationParameterValue
    ]] = Optional.Absent,
    resourceType: Optional[String] = Optional.Absent,
    automatic: Optional[Boolean] = Optional.Absent,
    executionControls: Optional[zio.aws.config.model.ExecutionControls] =
      Optional.Absent,
    maximumAutomaticAttempts: Optional[AutoRemediationAttempts] =
      Optional.Absent,
    retryAttemptSeconds: Optional[AutoRemediationAttemptSeconds] =
      Optional.Absent,
    arn: Optional[StringWithCharLimit1024] = Optional.Absent,
    createdByService: Optional[StringWithCharLimit1024] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.RemediationConfiguration = {
    import RemediationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.RemediationConfiguration
      .builder()
      .configRuleName(ConfigRuleName.unwrap(configRuleName): java.lang.String)
      .targetType(targetType.unwrap)
      .targetId(StringWithCharLimit256.unwrap(targetId): java.lang.String)
      .optionallyWith(targetVersion.map(value => value: java.lang.String))(
        _.targetVersion
      )
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (StringWithCharLimit256.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(resourceType.map(value => value: java.lang.String))(
        _.resourceType
      )
      .optionallyWith(automatic.map(value => value: java.lang.Boolean))(
        _.automatic
      )
      .optionallyWith(executionControls.map(value => value.buildAwsValue()))(
        _.executionControls
      )
      .optionallyWith(
        maximumAutomaticAttempts.map(value =>
          AutoRemediationAttempts.unwrap(value): Integer
        )
      )(_.maximumAutomaticAttempts)
      .optionallyWith(
        retryAttemptSeconds.map(value =>
          AutoRemediationAttemptSeconds.unwrap(value): java.lang.Long
        )
      )(_.retryAttemptSeconds)
      .optionallyWith(
        arn.map(value =>
          StringWithCharLimit1024.unwrap(value): java.lang.String
        )
      )(_.arn)
      .optionallyWith(
        createdByService.map(value =>
          StringWithCharLimit1024.unwrap(value): java.lang.String
        )
      )(_.createdByService)
      .build()
  }
  def asReadOnly: zio.aws.config.model.RemediationConfiguration.ReadOnly =
    zio.aws.config.model.RemediationConfiguration.wrap(buildAwsValue())
}
object RemediationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.RemediationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.RemediationConfiguration =
      zio.aws.config.model.RemediationConfiguration(
        configRuleName,
        targetType,
        targetId,
        targetVersion.map(value => value),
        parameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        resourceType.map(value => value),
        automatic.map(value => value),
        executionControls.map(value => value.asEditable),
        maximumAutomaticAttempts.map(value => value),
        retryAttemptSeconds.map(value => value),
        arn.map(value => value),
        createdByService.map(value => value)
      )
    def configRuleName: ConfigRuleName
    def targetType: zio.aws.config.model.RemediationTargetType
    def targetId: StringWithCharLimit256
    def targetVersion: Optional[String]
    def parameters: Optional[Map[
      StringWithCharLimit256,
      zio.aws.config.model.RemediationParameterValue.ReadOnly
    ]]
    def resourceType: Optional[String]
    def automatic: Optional[Boolean]
    def executionControls
        : Optional[zio.aws.config.model.ExecutionControls.ReadOnly]
    def maximumAutomaticAttempts: Optional[AutoRemediationAttempts]
    def retryAttemptSeconds: Optional[AutoRemediationAttemptSeconds]
    def arn: Optional[StringWithCharLimit1024]
    def createdByService: Optional[StringWithCharLimit1024]
    def getConfigRuleName: ZIO[Any, Nothing, ConfigRuleName] =
      ZIO.succeed(configRuleName)
    def getTargetType
        : ZIO[Any, Nothing, zio.aws.config.model.RemediationTargetType] =
      ZIO.succeed(targetType)
    def getTargetId: ZIO[Any, Nothing, StringWithCharLimit256] =
      ZIO.succeed(targetId)
    def getTargetVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetVersion", targetVersion)
    def getParameters: ZIO[Any, AwsError, Map[
      StringWithCharLimit256,
      zio.aws.config.model.RemediationParameterValue.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getResourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getAutomatic: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("automatic", automatic)
    def getExecutionControls
        : ZIO[Any, AwsError, zio.aws.config.model.ExecutionControls.ReadOnly] =
      AwsError.unwrapOptionField("executionControls", executionControls)
    def getMaximumAutomaticAttempts
        : ZIO[Any, AwsError, AutoRemediationAttempts] = AwsError
      .unwrapOptionField("maximumAutomaticAttempts", maximumAutomaticAttempts)
    def getRetryAttemptSeconds
        : ZIO[Any, AwsError, AutoRemediationAttemptSeconds] =
      AwsError.unwrapOptionField("retryAttemptSeconds", retryAttemptSeconds)
    def getArn: ZIO[Any, AwsError, StringWithCharLimit1024] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedByService: ZIO[Any, AwsError, StringWithCharLimit1024] =
      AwsError.unwrapOptionField("createdByService", createdByService)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.RemediationConfiguration
  ) extends zio.aws.config.model.RemediationConfiguration.ReadOnly {
    override val configRuleName: ConfigRuleName =
      zio.aws.config.model.primitives.ConfigRuleName(impl.configRuleName())
    override val targetType: zio.aws.config.model.RemediationTargetType =
      zio.aws.config.model.RemediationTargetType.wrap(impl.targetType())
    override val targetId: StringWithCharLimit256 =
      zio.aws.config.model.primitives.StringWithCharLimit256(impl.targetId())
    override val targetVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetVersion())
      .map(value => value: String)
    override val parameters: Optional[Map[
      StringWithCharLimit256,
      zio.aws.config.model.RemediationParameterValue.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.config.model.primitives.StringWithCharLimit256(
              key
            ) -> zio.aws.config.model.RemediationParameterValue.wrap(value)
          })
          .toMap
      )
    override val resourceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => value: String)
    override val automatic: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.automatic())
      .map(value => value: Boolean)
    override val executionControls
        : Optional[zio.aws.config.model.ExecutionControls.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionControls())
        .map(value => zio.aws.config.model.ExecutionControls.wrap(value))
    override val maximumAutomaticAttempts: Optional[AutoRemediationAttempts] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumAutomaticAttempts())
        .map(value =>
          zio.aws.config.model.primitives.AutoRemediationAttempts(value)
        )
    override val retryAttemptSeconds: Optional[AutoRemediationAttemptSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryAttemptSeconds())
        .map(value =>
          zio.aws.config.model.primitives.AutoRemediationAttemptSeconds(value)
        )
    override val arn: Optional[StringWithCharLimit1024] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit1024(value)
      )
    override val createdByService: Optional[StringWithCharLimit1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdByService())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit1024(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.RemediationConfiguration
  ): zio.aws.config.model.RemediationConfiguration.ReadOnly = new Wrapper(impl)
}
