package zio.aws.config.model
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{
  NextToken,
  AccountId,
  ConfigurationAggregatorName,
  Limit,
  ConfigRuleName,
  AwsRegion
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetAggregateComplianceDetailsByConfigRuleRequest(
    configurationAggregatorName: ConfigurationAggregatorName,
    configRuleName: ConfigRuleName,
    accountId: AccountId,
    awsRegion: AwsRegion,
    complianceType: Optional[zio.aws.config.model.ComplianceType] =
      Optional.Absent,
    limit: Optional[Limit] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest = {
    import GetAggregateComplianceDetailsByConfigRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest
      .builder()
      .configurationAggregatorName(
        ConfigurationAggregatorName.unwrap(
          configurationAggregatorName
        ): java.lang.String
      )
      .configRuleName(ConfigRuleName.unwrap(configRuleName): java.lang.String)
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .awsRegion(AwsRegion.unwrap(awsRegion): java.lang.String)
      .optionallyWith(complianceType.map(value => value.unwrap))(
        _.complianceType
      )
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleRequest.ReadOnly =
    zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleRequest
      .wrap(buildAwsValue())
}
object GetAggregateComplianceDetailsByConfigRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleRequest =
      zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleRequest(
        configurationAggregatorName,
        configRuleName,
        accountId,
        awsRegion,
        complianceType.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def configurationAggregatorName: ConfigurationAggregatorName
    def configRuleName: ConfigRuleName
    def accountId: AccountId
    def awsRegion: AwsRegion
    def complianceType: Optional[zio.aws.config.model.ComplianceType]
    def limit: Optional[Limit]
    def nextToken: Optional[NextToken]
    def getConfigurationAggregatorName
        : ZIO[Any, Nothing, ConfigurationAggregatorName] =
      ZIO.succeed(configurationAggregatorName)
    def getConfigRuleName: ZIO[Any, Nothing, ConfigRuleName] =
      ZIO.succeed(configRuleName)
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getAwsRegion: ZIO[Any, Nothing, AwsRegion] = ZIO.succeed(awsRegion)
    def getComplianceType
        : ZIO[Any, AwsError, zio.aws.config.model.ComplianceType] =
      AwsError.unwrapOptionField("complianceType", complianceType)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest
  ) extends zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleRequest.ReadOnly {
    override val configurationAggregatorName: ConfigurationAggregatorName =
      zio.aws.config.model.primitives
        .ConfigurationAggregatorName(impl.configurationAggregatorName())
    override val configRuleName: ConfigRuleName =
      zio.aws.config.model.primitives.ConfigRuleName(impl.configRuleName())
    override val accountId: AccountId =
      zio.aws.config.model.primitives.AccountId(impl.accountId())
    override val awsRegion: AwsRegion =
      zio.aws.config.model.primitives.AwsRegion(impl.awsRegion())
    override val complianceType: Optional[zio.aws.config.model.ComplianceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceType())
        .map(value => zio.aws.config.model.ComplianceType.wrap(value))
    override val limit: Optional[Limit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.config.model.primitives.Limit(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest
  ): zio.aws.config.model.GetAggregateComplianceDetailsByConfigRuleRequest.ReadOnly =
    new Wrapper(impl)
}
