package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  StringWithCharLimit64,
  StringWithCharLimit1024,
  StringWithCharLimit256,
  EmptiableStringWithCharLimit256,
  ConfigRuleName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConfigRule(
    configRuleName: Optional[ConfigRuleName] = Optional.Absent,
    configRuleArn: Optional[StringWithCharLimit256] = Optional.Absent,
    configRuleId: Optional[StringWithCharLimit64] = Optional.Absent,
    description: Optional[EmptiableStringWithCharLimit256] = Optional.Absent,
    scope: Optional[zio.aws.config.model.Scope] = Optional.Absent,
    source: zio.aws.config.model.Source,
    inputParameters: Optional[StringWithCharLimit1024] = Optional.Absent,
    maximumExecutionFrequency: Optional[
      zio.aws.config.model.MaximumExecutionFrequency
    ] = Optional.Absent,
    configRuleState: Optional[zio.aws.config.model.ConfigRuleState] =
      Optional.Absent,
    createdBy: Optional[StringWithCharLimit256] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConfigRule = {
    import ConfigRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConfigRule
      .builder()
      .optionallyWith(
        configRuleName.map(value =>
          ConfigRuleName.unwrap(value): java.lang.String
        )
      )(_.configRuleName)
      .optionallyWith(
        configRuleArn.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.configRuleArn)
      .optionallyWith(
        configRuleId.map(value =>
          StringWithCharLimit64.unwrap(value): java.lang.String
        )
      )(_.configRuleId)
      .optionallyWith(
        description.map(value =>
          EmptiableStringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(scope.map(value => value.buildAwsValue()))(_.scope)
      .source(source.buildAwsValue())
      .optionallyWith(
        inputParameters.map(value =>
          StringWithCharLimit1024.unwrap(value): java.lang.String
        )
      )(_.inputParameters)
      .optionallyWith(maximumExecutionFrequency.map(value => value.unwrap))(
        _.maximumExecutionFrequency
      )
      .optionallyWith(configRuleState.map(value => value.unwrap))(
        _.configRuleState
      )
      .optionallyWith(
        createdBy.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.createdBy)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ConfigRule.ReadOnly =
    zio.aws.config.model.ConfigRule.wrap(buildAwsValue())
}
object ConfigRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.config.model.ConfigRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConfigRule =
      zio.aws.config.model.ConfigRule(
        configRuleName.map(value => value),
        configRuleArn.map(value => value),
        configRuleId.map(value => value),
        description.map(value => value),
        scope.map(value => value.asEditable),
        source.asEditable,
        inputParameters.map(value => value),
        maximumExecutionFrequency.map(value => value),
        configRuleState.map(value => value),
        createdBy.map(value => value)
      )
    def configRuleName: Optional[ConfigRuleName]
    def configRuleArn: Optional[StringWithCharLimit256]
    def configRuleId: Optional[StringWithCharLimit64]
    def description: Optional[EmptiableStringWithCharLimit256]
    def scope: Optional[zio.aws.config.model.Scope.ReadOnly]
    def source: zio.aws.config.model.Source.ReadOnly
    def inputParameters: Optional[StringWithCharLimit1024]
    def maximumExecutionFrequency
        : Optional[zio.aws.config.model.MaximumExecutionFrequency]
    def configRuleState: Optional[zio.aws.config.model.ConfigRuleState]
    def createdBy: Optional[StringWithCharLimit256]
    def getConfigRuleName: ZIO[Any, AwsError, ConfigRuleName] =
      AwsError.unwrapOptionField("configRuleName", configRuleName)
    def getConfigRuleArn: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("configRuleArn", configRuleArn)
    def getConfigRuleId: ZIO[Any, AwsError, StringWithCharLimit64] =
      AwsError.unwrapOptionField("configRuleId", configRuleId)
    def getDescription: ZIO[Any, AwsError, EmptiableStringWithCharLimit256] =
      AwsError.unwrapOptionField("description", description)
    def getScope: ZIO[Any, AwsError, zio.aws.config.model.Scope.ReadOnly] =
      AwsError.unwrapOptionField("scope", scope)
    def getSource: ZIO[Any, Nothing, zio.aws.config.model.Source.ReadOnly] =
      ZIO.succeed(source)
    def getInputParameters: ZIO[Any, AwsError, StringWithCharLimit1024] =
      AwsError.unwrapOptionField("inputParameters", inputParameters)
    def getMaximumExecutionFrequency
        : ZIO[Any, AwsError, zio.aws.config.model.MaximumExecutionFrequency] =
      AwsError.unwrapOptionField(
        "maximumExecutionFrequency",
        maximumExecutionFrequency
      )
    def getConfigRuleState
        : ZIO[Any, AwsError, zio.aws.config.model.ConfigRuleState] =
      AwsError.unwrapOptionField("configRuleState", configRuleState)
    def getCreatedBy: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("createdBy", createdBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConfigRule
  ) extends zio.aws.config.model.ConfigRule.ReadOnly {
    override val configRuleName: Optional[ConfigRuleName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configRuleName())
        .map(value => zio.aws.config.model.primitives.ConfigRuleName(value))
    override val configRuleArn: Optional[StringWithCharLimit256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configRuleArn())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit256(value)
        )
    override val configRuleId: Optional[StringWithCharLimit64] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configRuleId())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit64(value)
        )
    override val description: Optional[EmptiableStringWithCharLimit256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.config.model.primitives.EmptiableStringWithCharLimit256(value)
        )
    override val scope: Optional[zio.aws.config.model.Scope.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scope())
        .map(value => zio.aws.config.model.Scope.wrap(value))
    override val source: zio.aws.config.model.Source.ReadOnly =
      zio.aws.config.model.Source.wrap(impl.source())
    override val inputParameters: Optional[StringWithCharLimit1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputParameters())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit1024(value)
        )
    override val maximumExecutionFrequency
        : Optional[zio.aws.config.model.MaximumExecutionFrequency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumExecutionFrequency())
        .map(value =>
          zio.aws.config.model.MaximumExecutionFrequency.wrap(value)
        )
    override val configRuleState
        : Optional[zio.aws.config.model.ConfigRuleState] = zio.aws.core.internal
      .optionalFromNullable(impl.configRuleState())
      .map(value => zio.aws.config.model.ConfigRuleState.wrap(value))
    override val createdBy: Optional[StringWithCharLimit256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit256(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConfigRule
  ): zio.aws.config.model.ConfigRule.ReadOnly = new Wrapper(impl)
}
