package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutEvaluationsRequest(
    evaluations: Optional[Iterable[zio.aws.config.model.Evaluation]] =
      Optional.Absent,
    resultToken: String,
    testMode: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutEvaluationsRequest = {
    import PutEvaluationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutEvaluationsRequest
      .builder()
      .optionallyWith(
        evaluations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.evaluations)
      .resultToken(resultToken: java.lang.String)
      .optionallyWith(testMode.map(value => value: java.lang.Boolean))(
        _.testMode
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.PutEvaluationsRequest.ReadOnly =
    zio.aws.config.model.PutEvaluationsRequest.wrap(buildAwsValue())
}
object PutEvaluationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutEvaluationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutEvaluationsRequest =
      zio.aws.config.model.PutEvaluationsRequest(
        evaluations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resultToken,
        testMode.map(value => value)
      )
    def evaluations: Optional[List[zio.aws.config.model.Evaluation.ReadOnly]]
    def resultToken: String
    def testMode: Optional[Boolean]
    def getEvaluations
        : ZIO[Any, AwsError, List[zio.aws.config.model.Evaluation.ReadOnly]] =
      AwsError.unwrapOptionField("evaluations", evaluations)
    def getResultToken: ZIO[Any, Nothing, String] = ZIO.succeed(resultToken)
    def getTestMode: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("testMode", testMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutEvaluationsRequest
  ) extends zio.aws.config.model.PutEvaluationsRequest.ReadOnly {
    override val evaluations
        : Optional[List[zio.aws.config.model.Evaluation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.Evaluation.wrap(item)
          }.toList
        )
    override val resultToken: String = impl.resultToken(): String
    override val testMode: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.testMode())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutEvaluationsRequest
  ): zio.aws.config.model.PutEvaluationsRequest.ReadOnly = new Wrapper(impl)
}
