package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{AwsRegion, AccountId, ConfigRuleName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConfigRuleComplianceFilters(
    configRuleName: Optional[ConfigRuleName] = Optional.Absent,
    complianceType: Optional[zio.aws.config.model.ComplianceType] =
      Optional.Absent,
    accountId: Optional[AccountId] = Optional.Absent,
    awsRegion: Optional[AwsRegion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConfigRuleComplianceFilters = {
    import ConfigRuleComplianceFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConfigRuleComplianceFilters
      .builder()
      .optionallyWith(
        configRuleName.map(value =>
          ConfigRuleName.unwrap(value): java.lang.String
        )
      )(_.configRuleName)
      .optionallyWith(complianceType.map(value => value.unwrap))(
        _.complianceType
      )
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        awsRegion.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.awsRegion)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ConfigRuleComplianceFilters.ReadOnly =
    zio.aws.config.model.ConfigRuleComplianceFilters.wrap(buildAwsValue())
}
object ConfigRuleComplianceFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConfigRuleComplianceFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConfigRuleComplianceFilters =
      zio.aws.config.model.ConfigRuleComplianceFilters(
        configRuleName.map(value => value),
        complianceType.map(value => value),
        accountId.map(value => value),
        awsRegion.map(value => value)
      )
    def configRuleName: Optional[ConfigRuleName]
    def complianceType: Optional[zio.aws.config.model.ComplianceType]
    def accountId: Optional[AccountId]
    def awsRegion: Optional[AwsRegion]
    def getConfigRuleName: ZIO[Any, AwsError, ConfigRuleName] =
      AwsError.unwrapOptionField("configRuleName", configRuleName)
    def getComplianceType
        : ZIO[Any, AwsError, zio.aws.config.model.ComplianceType] =
      AwsError.unwrapOptionField("complianceType", complianceType)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAwsRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConfigRuleComplianceFilters
  ) extends zio.aws.config.model.ConfigRuleComplianceFilters.ReadOnly {
    override val configRuleName: Optional[ConfigRuleName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configRuleName())
        .map(value => zio.aws.config.model.primitives.ConfigRuleName(value))
    override val complianceType: Optional[zio.aws.config.model.ComplianceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceType())
        .map(value => zio.aws.config.model.ComplianceType.wrap(value))
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.config.model.primitives.AccountId(value))
    override val awsRegion: Optional[AwsRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.awsRegion())
      .map(value => zio.aws.config.model.primitives.AwsRegion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConfigRuleComplianceFilters
  ): zio.aws.config.model.ConfigRuleComplianceFilters.ReadOnly = new Wrapper(
    impl
  )
}
