package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait ComplianceType {
  def unwrap: software.amazon.awssdk.services.config.model.ComplianceType
}
object ComplianceType {
  def wrap(
      value: software.amazon.awssdk.services.config.model.ComplianceType
  ): zio.aws.config.model.ComplianceType = value match {
    case software.amazon.awssdk.services.config.model.ComplianceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.ComplianceType.COMPLIANT =>
      val r = COMPLIANT
      r
    case software.amazon.awssdk.services.config.model.ComplianceType.NON_COMPLIANT =>
      val r = NON_COMPLIANT
      r
    case software.amazon.awssdk.services.config.model.ComplianceType.NOT_APPLICABLE =>
      val r = NOT_APPLICABLE
      r
    case software.amazon.awssdk.services.config.model.ComplianceType.INSUFFICIENT_DATA =>
      val r = INSUFFICIENT_DATA
      r
  }
  case object unknownToSdkVersion extends zio.aws.config.model.ComplianceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ComplianceType =
      software.amazon.awssdk.services.config.model.ComplianceType.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLIANT extends zio.aws.config.model.ComplianceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ComplianceType =
      software.amazon.awssdk.services.config.model.ComplianceType.COMPLIANT
  }
  case object NON_COMPLIANT extends zio.aws.config.model.ComplianceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ComplianceType =
      software.amazon.awssdk.services.config.model.ComplianceType.NON_COMPLIANT
  }
  case object NOT_APPLICABLE extends zio.aws.config.model.ComplianceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ComplianceType =
      software.amazon.awssdk.services.config.model.ComplianceType.NOT_APPLICABLE
  }
  case object INSUFFICIENT_DATA extends zio.aws.config.model.ComplianceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ComplianceType =
      software.amazon.awssdk.services.config.model.ComplianceType.INSUFFICIENT_DATA
  }
}
