package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.StringWithCharLimit256
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AggregateComplianceCount(
    groupName: Optional[StringWithCharLimit256] = Optional.Absent,
    complianceSummary: Optional[zio.aws.config.model.ComplianceSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.AggregateComplianceCount = {
    import AggregateComplianceCount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.AggregateComplianceCount
      .builder()
      .optionallyWith(
        groupName.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .optionallyWith(complianceSummary.map(value => value.buildAwsValue()))(
        _.complianceSummary
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.AggregateComplianceCount.ReadOnly =
    zio.aws.config.model.AggregateComplianceCount.wrap(buildAwsValue())
}
object AggregateComplianceCount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.AggregateComplianceCount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.AggregateComplianceCount =
      zio.aws.config.model.AggregateComplianceCount(
        groupName.map(value => value),
        complianceSummary.map(value => value.asEditable)
      )
    def groupName: Optional[StringWithCharLimit256]
    def complianceSummary
        : Optional[zio.aws.config.model.ComplianceSummary.ReadOnly]
    def getGroupName: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getComplianceSummary
        : ZIO[Any, AwsError, zio.aws.config.model.ComplianceSummary.ReadOnly] =
      AwsError.unwrapOptionField("complianceSummary", complianceSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.AggregateComplianceCount
  ) extends zio.aws.config.model.AggregateComplianceCount.ReadOnly {
    override val groupName: Optional[StringWithCharLimit256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupName())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit256(value)
        )
    override val complianceSummary
        : Optional[zio.aws.config.model.ComplianceSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceSummary())
        .map(value => zio.aws.config.model.ComplianceSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.AggregateComplianceCount
  ): zio.aws.config.model.AggregateComplianceCount.ReadOnly = new Wrapper(impl)
}
