package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait RemediationExecutionStepState {
  def unwrap: software.amazon.awssdk.services.config.model.RemediationExecutionStepState
}
object RemediationExecutionStepState {
  def wrap(
      value: software.amazon.awssdk.services.config.model.RemediationExecutionStepState
  ): zio.aws.config.model.RemediationExecutionStepState = value match {
    case software.amazon.awssdk.services.config.model.RemediationExecutionStepState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.RemediationExecutionStepState.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.config.model.RemediationExecutionStepState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.config.model.RemediationExecutionStepState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.config.model.RemediationExecutionStepState {
    override def unwrap
        : software.amazon.awssdk.services.config.model.RemediationExecutionStepState =
      software.amazon.awssdk.services.config.model.RemediationExecutionStepState.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCEEDED
      extends zio.aws.config.model.RemediationExecutionStepState {
    override def unwrap
        : software.amazon.awssdk.services.config.model.RemediationExecutionStepState =
      software.amazon.awssdk.services.config.model.RemediationExecutionStepState.SUCCEEDED
  }
  case object PENDING
      extends zio.aws.config.model.RemediationExecutionStepState {
    override def unwrap
        : software.amazon.awssdk.services.config.model.RemediationExecutionStepState =
      software.amazon.awssdk.services.config.model.RemediationExecutionStepState.PENDING
  }
  case object FAILED
      extends zio.aws.config.model.RemediationExecutionStepState {
    override def unwrap
        : software.amazon.awssdk.services.config.model.RemediationExecutionStepState =
      software.amazon.awssdk.services.config.model.RemediationExecutionStepState.FAILED
  }
}
