package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.Date
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class RemediationExecutionStep(
    name: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.config.model.RemediationExecutionStepState] =
      Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent,
    startTime: Optional[Date] = Optional.Absent,
    stopTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.RemediationExecutionStep = {
    import RemediationExecutionStep.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.RemediationExecutionStep
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(startTime.map(value => Date.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(stopTime.map(value => Date.unwrap(value): Instant))(
        _.stopTime
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.RemediationExecutionStep.ReadOnly =
    zio.aws.config.model.RemediationExecutionStep.wrap(buildAwsValue())
}
object RemediationExecutionStep {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.RemediationExecutionStep
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.RemediationExecutionStep =
      zio.aws.config.model.RemediationExecutionStep(
        name.map(value => value),
        state.map(value => value),
        errorMessage.map(value => value),
        startTime.map(value => value),
        stopTime.map(value => value)
      )
    def name: Optional[String]
    def state: Optional[zio.aws.config.model.RemediationExecutionStepState]
    def errorMessage: Optional[String]
    def startTime: Optional[Date]
    def stopTime: Optional[Date]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.RemediationExecutionStepState
    ] = AwsError.unwrapOptionField("state", state)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getStartTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStopTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("stopTime", stopTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.RemediationExecutionStep
  ) extends zio.aws.config.model.RemediationExecutionStep.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val state
        : Optional[zio.aws.config.model.RemediationExecutionStepState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.config.model.RemediationExecutionStepState.wrap(value)
        )
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
    override val startTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val stopTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.stopTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.RemediationExecutionStep
  ): zio.aws.config.model.RemediationExecutionStep.ReadOnly = new Wrapper(impl)
}
