package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{Date, StringWithCharLimit64, AccountId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class MemberAccountStatus(
    accountId: AccountId,
    configRuleName: StringWithCharLimit64,
    memberAccountRuleStatus: zio.aws.config.model.MemberAccountRuleStatus,
    errorCode: Optional[String] = Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent,
    lastUpdateTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.MemberAccountStatus = {
    import MemberAccountStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.MemberAccountStatus
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .configRuleName(
        StringWithCharLimit64.unwrap(configRuleName): java.lang.String
      )
      .memberAccountRuleStatus(memberAccountRuleStatus.unwrap)
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(lastUpdateTime.map(value => Date.unwrap(value): Instant))(
        _.lastUpdateTime
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.MemberAccountStatus.ReadOnly =
    zio.aws.config.model.MemberAccountStatus.wrap(buildAwsValue())
}
object MemberAccountStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.MemberAccountStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.MemberAccountStatus =
      zio.aws.config.model.MemberAccountStatus(
        accountId,
        configRuleName,
        memberAccountRuleStatus,
        errorCode.map(value => value),
        errorMessage.map(value => value),
        lastUpdateTime.map(value => value)
      )
    def accountId: AccountId
    def configRuleName: StringWithCharLimit64
    def memberAccountRuleStatus: zio.aws.config.model.MemberAccountRuleStatus
    def errorCode: Optional[String]
    def errorMessage: Optional[String]
    def lastUpdateTime: Optional[Date]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getConfigRuleName: ZIO[Any, Nothing, StringWithCharLimit64] =
      ZIO.succeed(configRuleName)
    def getMemberAccountRuleStatus
        : ZIO[Any, Nothing, zio.aws.config.model.MemberAccountRuleStatus] =
      ZIO.succeed(memberAccountRuleStatus)
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getLastUpdateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.MemberAccountStatus
  ) extends zio.aws.config.model.MemberAccountStatus.ReadOnly {
    override val accountId: AccountId =
      zio.aws.config.model.primitives.AccountId(impl.accountId())
    override val configRuleName: StringWithCharLimit64 =
      zio.aws.config.model.primitives
        .StringWithCharLimit64(impl.configRuleName())
    override val memberAccountRuleStatus
        : zio.aws.config.model.MemberAccountRuleStatus =
      zio.aws.config.model.MemberAccountRuleStatus
        .wrap(impl.memberAccountRuleStatus())
    override val errorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => value: String)
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
    override val lastUpdateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.MemberAccountStatus
  ): zio.aws.config.model.MemberAccountStatus.ReadOnly = new Wrapper(impl)
}
