package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{NextToken, StringWithCharLimit256}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAggregateDiscoveredResourceCountsResponse(
    totalDiscoveredResources: Long,
    groupByKey: Optional[StringWithCharLimit256] = Optional.Absent,
    groupedResourceCounts: Optional[
      Iterable[zio.aws.config.model.GroupedResourceCount]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse = {
    import GetAggregateDiscoveredResourceCountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse
      .builder()
      .totalDiscoveredResources(totalDiscoveredResources: java.lang.Long)
      .optionallyWith(
        groupByKey.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.groupByKey)
      .optionallyWith(
        groupedResourceCounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groupedResourceCounts)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetAggregateDiscoveredResourceCountsResponse.ReadOnly =
    zio.aws.config.model.GetAggregateDiscoveredResourceCountsResponse
      .wrap(buildAwsValue())
}
object GetAggregateDiscoveredResourceCountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetAggregateDiscoveredResourceCountsResponse =
      zio.aws.config.model.GetAggregateDiscoveredResourceCountsResponse(
        totalDiscoveredResources,
        groupByKey.map(value => value),
        groupedResourceCounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def totalDiscoveredResources: Long
    def groupByKey: Optional[StringWithCharLimit256]
    def groupedResourceCounts
        : Optional[List[zio.aws.config.model.GroupedResourceCount.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getTotalDiscoveredResources: ZIO[Any, Nothing, Long] =
      ZIO.succeed(totalDiscoveredResources)
    def getGroupByKey: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("groupByKey", groupByKey)
    def getGroupedResourceCounts: ZIO[Any, AwsError, List[
      zio.aws.config.model.GroupedResourceCount.ReadOnly
    ]] =
      AwsError.unwrapOptionField("groupedResourceCounts", groupedResourceCounts)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse
  ) extends zio.aws.config.model.GetAggregateDiscoveredResourceCountsResponse.ReadOnly {
    override val totalDiscoveredResources: Long =
      impl.totalDiscoveredResources(): Long
    override val groupByKey: Optional[StringWithCharLimit256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupByKey())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit256(value)
        )
    override val groupedResourceCounts
        : Optional[List[zio.aws.config.model.GroupedResourceCount.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupedResourceCounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.GroupedResourceCount.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse
  ): zio.aws.config.model.GetAggregateDiscoveredResourceCountsResponse.ReadOnly =
    new Wrapper(impl)
}
