package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.RecorderName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeConfigurationRecorderStatusRequest(
    configurationRecorderNames: Optional[Iterable[RecorderName]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusRequest = {
    import DescribeConfigurationRecorderStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusRequest
      .builder()
      .optionallyWith(
        configurationRecorderNames.map(value =>
          value.map { item =>
            RecorderName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.configurationRecorderNames)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeConfigurationRecorderStatusRequest.ReadOnly =
    zio.aws.config.model.DescribeConfigurationRecorderStatusRequest
      .wrap(buildAwsValue())
}
object DescribeConfigurationRecorderStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeConfigurationRecorderStatusRequest =
      zio.aws.config.model.DescribeConfigurationRecorderStatusRequest(
        configurationRecorderNames.map(value => value)
      )
    def configurationRecorderNames: Optional[List[RecorderName]]
    def getConfigurationRecorderNames: ZIO[Any, AwsError, List[RecorderName]] =
      AwsError.unwrapOptionField(
        "configurationRecorderNames",
        configurationRecorderNames
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusRequest
  ) extends zio.aws.config.model.DescribeConfigurationRecorderStatusRequest.ReadOnly {
    override val configurationRecorderNames: Optional[List[RecorderName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationRecorderNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.primitives.RecorderName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusRequest
  ): zio.aws.config.model.DescribeConfigurationRecorderStatusRequest.ReadOnly =
    new Wrapper(impl)
}
