package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait DeliveryStatus {
  def unwrap: software.amazon.awssdk.services.config.model.DeliveryStatus
}
object DeliveryStatus {
  def wrap(
      value: software.amazon.awssdk.services.config.model.DeliveryStatus
  ): zio.aws.config.model.DeliveryStatus = value match {
    case software.amazon.awssdk.services.config.model.DeliveryStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.DeliveryStatus.SUCCESS =>
      val r = Success
      r
    case software.amazon.awssdk.services.config.model.DeliveryStatus.FAILURE =>
      val r = Failure
      r
    case software.amazon.awssdk.services.config.model.DeliveryStatus.NOT_APPLICABLE =>
      val r = Not_Applicable
      r
  }
  case object unknownToSdkVersion extends zio.aws.config.model.DeliveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.config.model.DeliveryStatus =
      software.amazon.awssdk.services.config.model.DeliveryStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Success extends zio.aws.config.model.DeliveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.config.model.DeliveryStatus =
      software.amazon.awssdk.services.config.model.DeliveryStatus.SUCCESS
  }
  case object Failure extends zio.aws.config.model.DeliveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.config.model.DeliveryStatus =
      software.amazon.awssdk.services.config.model.DeliveryStatus.FAILURE
  }
  case object Not_Applicable extends zio.aws.config.model.DeliveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.config.model.DeliveryStatus =
      software.amazon.awssdk.services.config.model.DeliveryStatus.NOT_APPLICABLE
  }
}
