package zio.aws.config.model
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{NextToken, Limit, Expression}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SelectResourceConfigRequest(
    expression: Expression,
    limit: Optional[Limit] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.SelectResourceConfigRequest = {
    import SelectResourceConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.SelectResourceConfigRequest
      .builder()
      .expression(Expression.unwrap(expression): java.lang.String)
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.config.model.SelectResourceConfigRequest.ReadOnly =
    zio.aws.config.model.SelectResourceConfigRequest.wrap(buildAwsValue())
}
object SelectResourceConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.SelectResourceConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.SelectResourceConfigRequest =
      zio.aws.config.model.SelectResourceConfigRequest(
        expression,
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def expression: Expression
    def limit: Optional[Limit]
    def nextToken: Optional[NextToken]
    def getExpression: ZIO[Any, Nothing, Expression] = ZIO.succeed(expression)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.SelectResourceConfigRequest
  ) extends zio.aws.config.model.SelectResourceConfigRequest.ReadOnly {
    override val expression: Expression =
      zio.aws.config.model.primitives.Expression(impl.expression())
    override val limit: Optional[Limit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.config.model.primitives.Limit(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.SelectResourceConfigRequest
  ): zio.aws.config.model.SelectResourceConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
