package zio.aws.config.model
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{
  NextToken,
  Limit,
  ResourceName,
  ResourceId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDiscoveredResourcesRequest(
    resourceType: zio.aws.config.model.ResourceType,
    resourceIds: Optional[Iterable[ResourceId]] = Optional.Absent,
    resourceName: Optional[ResourceName] = Optional.Absent,
    limit: Optional[Limit] = Optional.Absent,
    includeDeletedResources: Optional[Boolean] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest = {
    import ListDiscoveredResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest
      .builder()
      .resourceType(resourceType.unwrap)
      .optionallyWith(
        resourceIds.map(value =>
          value.map { item =>
            ResourceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceIds)
      .optionallyWith(
        resourceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resourceName)
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .optionallyWith(
        includeDeletedResources.map(value => value: java.lang.Boolean)
      )(_.includeDeletedResources)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ListDiscoveredResourcesRequest.ReadOnly =
    zio.aws.config.model.ListDiscoveredResourcesRequest.wrap(buildAwsValue())
}
object ListDiscoveredResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ListDiscoveredResourcesRequest =
      zio.aws.config.model.ListDiscoveredResourcesRequest(
        resourceType,
        resourceIds.map(value => value),
        resourceName.map(value => value),
        limit.map(value => value),
        includeDeletedResources.map(value => value),
        nextToken.map(value => value)
      )
    def resourceType: zio.aws.config.model.ResourceType
    def resourceIds: Optional[List[ResourceId]]
    def resourceName: Optional[ResourceName]
    def limit: Optional[Limit]
    def includeDeletedResources: Optional[Boolean]
    def nextToken: Optional[NextToken]
    def getResourceType: ZIO[Any, Nothing, zio.aws.config.model.ResourceType] =
      ZIO.succeed(resourceType)
    def getResourceIds: ZIO[Any, AwsError, List[ResourceId]] =
      AwsError.unwrapOptionField("resourceIds", resourceIds)
    def getResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
    def getIncludeDeletedResources: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("includeDeletedResources", includeDeletedResources)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest
  ) extends zio.aws.config.model.ListDiscoveredResourcesRequest.ReadOnly {
    override val resourceType: zio.aws.config.model.ResourceType =
      zio.aws.config.model.ResourceType.wrap(impl.resourceType())
    override val resourceIds: Optional[List[ResourceId]] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.primitives.ResourceId(item)
        }.toList
      )
    override val resourceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceName())
      .map(value => zio.aws.config.model.primitives.ResourceName(value))
    override val limit: Optional[Limit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.config.model.primitives.Limit(value))
    override val includeDeletedResources: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeDeletedResources())
        .map(value => value: Boolean)
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest
  ): zio.aws.config.model.ListDiscoveredResourcesRequest.ReadOnly = new Wrapper(
    impl
  )
}
