package zio.aws.config.model
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{
  NextToken,
  GroupByAPILimit,
  ConfigurationAggregatorName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetAggregateConfigRuleComplianceSummaryRequest(
    configurationAggregatorName: ConfigurationAggregatorName,
    filters: Optional[zio.aws.config.model.ConfigRuleComplianceSummaryFilters] =
      Optional.Absent,
    groupByKey: Optional[
      zio.aws.config.model.ConfigRuleComplianceSummaryGroupKey
    ] = Optional.Absent,
    limit: Optional[GroupByAPILimit] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest = {
    import GetAggregateConfigRuleComplianceSummaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest
      .builder()
      .configurationAggregatorName(
        ConfigurationAggregatorName.unwrap(
          configurationAggregatorName
        ): java.lang.String
      )
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(groupByKey.map(value => value.unwrap))(_.groupByKey)
      .optionallyWith(
        limit.map(value => GroupByAPILimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryRequest.ReadOnly =
    zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryRequest
      .wrap(buildAwsValue())
}
object GetAggregateConfigRuleComplianceSummaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryRequest =
      zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryRequest(
        configurationAggregatorName,
        filters.map(value => value.asEditable),
        groupByKey.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def configurationAggregatorName: ConfigurationAggregatorName
    def filters: Optional[
      zio.aws.config.model.ConfigRuleComplianceSummaryFilters.ReadOnly
    ]
    def groupByKey
        : Optional[zio.aws.config.model.ConfigRuleComplianceSummaryGroupKey]
    def limit: Optional[GroupByAPILimit]
    def nextToken: Optional[NextToken]
    def getConfigurationAggregatorName
        : ZIO[Any, Nothing, ConfigurationAggregatorName] =
      ZIO.succeed(configurationAggregatorName)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ConfigRuleComplianceSummaryFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getGroupByKey: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ConfigRuleComplianceSummaryGroupKey
    ] = AwsError.unwrapOptionField("groupByKey", groupByKey)
    def getLimit: ZIO[Any, AwsError, GroupByAPILimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest
  ) extends zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryRequest.ReadOnly {
    override val configurationAggregatorName: ConfigurationAggregatorName =
      zio.aws.config.model.primitives
        .ConfigurationAggregatorName(impl.configurationAggregatorName())
    override val filters: Optional[
      zio.aws.config.model.ConfigRuleComplianceSummaryFilters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        zio.aws.config.model.ConfigRuleComplianceSummaryFilters.wrap(value)
      )
    override val groupByKey
        : Optional[zio.aws.config.model.ConfigRuleComplianceSummaryGroupKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupByKey())
        .map(value =>
          zio.aws.config.model.ConfigRuleComplianceSummaryGroupKey.wrap(value)
        )
    override val limit: Optional[GroupByAPILimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.config.model.primitives.GroupByAPILimit(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest
  ): zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryRequest.ReadOnly =
    new Wrapper(impl)
}
