package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{StringWithCharLimit128, ConfigRuleName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConformancePackRuleCompliance(
    configRuleName: Optional[ConfigRuleName] = Optional.Absent,
    complianceType: Optional[
      zio.aws.config.model.ConformancePackComplianceType
    ] = Optional.Absent,
    controls: Optional[Iterable[StringWithCharLimit128]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConformancePackRuleCompliance = {
    import ConformancePackRuleCompliance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConformancePackRuleCompliance
      .builder()
      .optionallyWith(
        configRuleName.map(value =>
          ConfigRuleName.unwrap(value): java.lang.String
        )
      )(_.configRuleName)
      .optionallyWith(complianceType.map(value => value.unwrap))(
        _.complianceType
      )
      .optionallyWith(
        controls.map(value =>
          value.map { item =>
            StringWithCharLimit128.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.controls)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ConformancePackRuleCompliance.ReadOnly =
    zio.aws.config.model.ConformancePackRuleCompliance.wrap(buildAwsValue())
}
object ConformancePackRuleCompliance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConformancePackRuleCompliance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConformancePackRuleCompliance =
      zio.aws.config.model.ConformancePackRuleCompliance(
        configRuleName.map(value => value),
        complianceType.map(value => value),
        controls.map(value => value)
      )
    def configRuleName: Optional[ConfigRuleName]
    def complianceType
        : Optional[zio.aws.config.model.ConformancePackComplianceType]
    def controls: Optional[List[StringWithCharLimit128]]
    def getConfigRuleName: ZIO[Any, AwsError, ConfigRuleName] =
      AwsError.unwrapOptionField("configRuleName", configRuleName)
    def getComplianceType: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ConformancePackComplianceType
    ] = AwsError.unwrapOptionField("complianceType", complianceType)
    def getControls: ZIO[Any, AwsError, List[StringWithCharLimit128]] =
      AwsError.unwrapOptionField("controls", controls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConformancePackRuleCompliance
  ) extends zio.aws.config.model.ConformancePackRuleCompliance.ReadOnly {
    override val configRuleName: Optional[ConfigRuleName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configRuleName())
        .map(value => zio.aws.config.model.primitives.ConfigRuleName(value))
    override val complianceType
        : Optional[zio.aws.config.model.ConformancePackComplianceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceType())
        .map(value =>
          zio.aws.config.model.ConformancePackComplianceType.wrap(value)
        )
    override val controls: Optional[List[StringWithCharLimit128]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controls())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.primitives.StringWithCharLimit128(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConformancePackRuleCompliance
  ): zio.aws.config.model.ConformancePackRuleCompliance.ReadOnly = new Wrapper(
    impl
  )
}
