package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.{ParameterValue, ParameterName}
import scala.jdk.CollectionConverters.*
final case class ConformancePackInputParameter(
    parameterName: ParameterName,
    parameterValue: ParameterValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConformancePackInputParameter = {
    import ConformancePackInputParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConformancePackInputParameter
      .builder()
      .parameterName(ParameterName.unwrap(parameterName): java.lang.String)
      .parameterValue(ParameterValue.unwrap(parameterValue): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ConformancePackInputParameter.ReadOnly =
    zio.aws.config.model.ConformancePackInputParameter.wrap(buildAwsValue())
}
object ConformancePackInputParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConformancePackInputParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConformancePackInputParameter =
      zio.aws.config.model
        .ConformancePackInputParameter(parameterName, parameterValue)
    def parameterName: ParameterName
    def parameterValue: ParameterValue
    def getParameterName: ZIO[Any, Nothing, ParameterName] =
      ZIO.succeed(parameterName)
    def getParameterValue: ZIO[Any, Nothing, ParameterValue] =
      ZIO.succeed(parameterValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConformancePackInputParameter
  ) extends zio.aws.config.model.ConformancePackInputParameter.ReadOnly {
    override val parameterName: ParameterName =
      zio.aws.config.model.primitives.ParameterName(impl.parameterName())
    override val parameterValue: ParameterValue =
      zio.aws.config.model.primitives.ParameterValue(impl.parameterValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConformancePackInputParameter
  ): zio.aws.config.model.ConformancePackInputParameter.ReadOnly = new Wrapper(
    impl
  )
}
