package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.StringWithCharLimit256
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ComplianceSummaryByResourceType(
    resourceType: Optional[StringWithCharLimit256] = Optional.Absent,
    complianceSummary: Optional[zio.aws.config.model.ComplianceSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ComplianceSummaryByResourceType = {
    import ComplianceSummaryByResourceType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ComplianceSummaryByResourceType
      .builder()
      .optionallyWith(
        resourceType.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(complianceSummary.map(value => value.buildAwsValue()))(
        _.complianceSummary
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.ComplianceSummaryByResourceType.ReadOnly =
    zio.aws.config.model.ComplianceSummaryByResourceType.wrap(buildAwsValue())
}
object ComplianceSummaryByResourceType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ComplianceSummaryByResourceType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ComplianceSummaryByResourceType =
      zio.aws.config.model.ComplianceSummaryByResourceType(
        resourceType.map(value => value),
        complianceSummary.map(value => value.asEditable)
      )
    def resourceType: Optional[StringWithCharLimit256]
    def complianceSummary
        : Optional[zio.aws.config.model.ComplianceSummary.ReadOnly]
    def getResourceType: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getComplianceSummary
        : ZIO[Any, AwsError, zio.aws.config.model.ComplianceSummary.ReadOnly] =
      AwsError.unwrapOptionField("complianceSummary", complianceSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ComplianceSummaryByResourceType
  ) extends zio.aws.config.model.ComplianceSummaryByResourceType.ReadOnly {
    override val resourceType: Optional[StringWithCharLimit256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit256(value)
        )
    override val complianceSummary
        : Optional[zio.aws.config.model.ComplianceSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceSummary())
        .map(value => zio.aws.config.model.ComplianceSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ComplianceSummaryByResourceType
  ): zio.aws.config.model.ComplianceSummaryByResourceType.ReadOnly =
    new Wrapper(impl)
}
