package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.Date
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ComplianceSummary(
    compliantResourceCount: Optional[
      zio.aws.config.model.ComplianceContributorCount
    ] = Optional.Absent,
    nonCompliantResourceCount: Optional[
      zio.aws.config.model.ComplianceContributorCount
    ] = Optional.Absent,
    complianceSummaryTimestamp: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ComplianceSummary = {
    import ComplianceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ComplianceSummary
      .builder()
      .optionallyWith(
        compliantResourceCount.map(value => value.buildAwsValue())
      )(_.compliantResourceCount)
      .optionallyWith(
        nonCompliantResourceCount.map(value => value.buildAwsValue())
      )(_.nonCompliantResourceCount)
      .optionallyWith(
        complianceSummaryTimestamp.map(value => Date.unwrap(value): Instant)
      )(_.complianceSummaryTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ComplianceSummary.ReadOnly =
    zio.aws.config.model.ComplianceSummary.wrap(buildAwsValue())
}
object ComplianceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ComplianceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ComplianceSummary =
      zio.aws.config.model.ComplianceSummary(
        compliantResourceCount.map(value => value.asEditable),
        nonCompliantResourceCount.map(value => value.asEditable),
        complianceSummaryTimestamp.map(value => value)
      )
    def compliantResourceCount
        : Optional[zio.aws.config.model.ComplianceContributorCount.ReadOnly]
    def nonCompliantResourceCount
        : Optional[zio.aws.config.model.ComplianceContributorCount.ReadOnly]
    def complianceSummaryTimestamp: Optional[Date]
    def getCompliantResourceCount: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ComplianceContributorCount.ReadOnly
    ] = AwsError.unwrapOptionField(
      "compliantResourceCount",
      compliantResourceCount
    )
    def getNonCompliantResourceCount: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ComplianceContributorCount.ReadOnly
    ] = AwsError.unwrapOptionField(
      "nonCompliantResourceCount",
      nonCompliantResourceCount
    )
    def getComplianceSummaryTimestamp: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField(
        "complianceSummaryTimestamp",
        complianceSummaryTimestamp
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ComplianceSummary
  ) extends zio.aws.config.model.ComplianceSummary.ReadOnly {
    override val compliantResourceCount
        : Optional[zio.aws.config.model.ComplianceContributorCount.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compliantResourceCount())
        .map(value =>
          zio.aws.config.model.ComplianceContributorCount.wrap(value)
        )
    override val nonCompliantResourceCount
        : Optional[zio.aws.config.model.ComplianceContributorCount.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nonCompliantResourceCount())
        .map(value =>
          zio.aws.config.model.ComplianceContributorCount.wrap(value)
        )
    override val complianceSummaryTimestamp: Optional[Date] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceSummaryTimestamp())
        .map(value => zio.aws.config.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ComplianceSummary
  ): zio.aws.config.model.ComplianceSummary.ReadOnly = new Wrapper(impl)
}
