package zio.aws.config.model
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{NextToken, Limit, AmazonResourceName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(
    resourceArn: AmazonResourceName,
    limit: Optional[Limit] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.config.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ListTagsForResourceRequest =
      zio.aws.config.model.ListTagsForResourceRequest(
        resourceArn,
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def resourceArn: AmazonResourceName
    def limit: Optional[Limit]
    def nextToken: Optional[NextToken]
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ListTagsForResourceRequest
  ) extends zio.aws.config.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.config.model.primitives.AmazonResourceName(impl.resourceArn())
    override val limit: Optional[Limit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.config.model.primitives.Limit(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ListTagsForResourceRequest
  ): zio.aws.config.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
