package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.ChannelName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeDeliveryChannelsRequest(
    deliveryChannelNames: Optional[Iterable[ChannelName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsRequest = {
    import DescribeDeliveryChannelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsRequest
      .builder()
      .optionallyWith(
        deliveryChannelNames.map(value =>
          value.map { item =>
            ChannelName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.deliveryChannelNames)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeDeliveryChannelsRequest.ReadOnly =
    zio.aws.config.model.DescribeDeliveryChannelsRequest.wrap(buildAwsValue())
}
object DescribeDeliveryChannelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DescribeDeliveryChannelsRequest =
      zio.aws.config.model.DescribeDeliveryChannelsRequest(
        deliveryChannelNames.map(value => value)
      )
    def deliveryChannelNames: Optional[List[ChannelName]]
    def getDeliveryChannelNames: ZIO[Any, AwsError, List[ChannelName]] =
      AwsError.unwrapOptionField("deliveryChannelNames", deliveryChannelNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsRequest
  ) extends zio.aws.config.model.DescribeDeliveryChannelsRequest.ReadOnly {
    override val deliveryChannelNames: Optional[List[ChannelName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliveryChannelNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.primitives.ChannelName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsRequest
  ): zio.aws.config.model.DescribeDeliveryChannelsRequest.ReadOnly =
    new Wrapper(impl)
}
