package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{
  StringWithCharLimit256,
  Date,
  ConfigurationAggregatorArn,
  ConfigurationAggregatorName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ConfigurationAggregator(
    configurationAggregatorName: Optional[ConfigurationAggregatorName] =
      Optional.Absent,
    configurationAggregatorArn: Optional[ConfigurationAggregatorArn] =
      Optional.Absent,
    accountAggregationSources: Optional[
      Iterable[zio.aws.config.model.AccountAggregationSource]
    ] = Optional.Absent,
    organizationAggregationSource: Optional[
      zio.aws.config.model.OrganizationAggregationSource
    ] = Optional.Absent,
    creationTime: Optional[Date] = Optional.Absent,
    lastUpdatedTime: Optional[Date] = Optional.Absent,
    createdBy: Optional[StringWithCharLimit256] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConfigurationAggregator = {
    import ConfigurationAggregator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConfigurationAggregator
      .builder()
      .optionallyWith(
        configurationAggregatorName.map(value =>
          ConfigurationAggregatorName.unwrap(value): java.lang.String
        )
      )(_.configurationAggregatorName)
      .optionallyWith(
        configurationAggregatorArn.map(value =>
          ConfigurationAggregatorArn.unwrap(value): java.lang.String
        )
      )(_.configurationAggregatorArn)
      .optionallyWith(
        accountAggregationSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountAggregationSources)
      .optionallyWith(
        organizationAggregationSource.map(value => value.buildAwsValue())
      )(_.organizationAggregationSource)
      .optionallyWith(creationTime.map(value => Date.unwrap(value): Instant))(
        _.creationTime
      )
      .optionallyWith(
        lastUpdatedTime.map(value => Date.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        createdBy.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.createdBy)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ConfigurationAggregator.ReadOnly =
    zio.aws.config.model.ConfigurationAggregator.wrap(buildAwsValue())
}
object ConfigurationAggregator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConfigurationAggregator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConfigurationAggregator =
      zio.aws.config.model.ConfigurationAggregator(
        configurationAggregatorName.map(value => value),
        configurationAggregatorArn.map(value => value),
        accountAggregationSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        organizationAggregationSource.map(value => value.asEditable),
        creationTime.map(value => value),
        lastUpdatedTime.map(value => value),
        createdBy.map(value => value)
      )
    def configurationAggregatorName: Optional[ConfigurationAggregatorName]
    def configurationAggregatorArn: Optional[ConfigurationAggregatorArn]
    def accountAggregationSources
        : Optional[List[zio.aws.config.model.AccountAggregationSource.ReadOnly]]
    def organizationAggregationSource
        : Optional[zio.aws.config.model.OrganizationAggregationSource.ReadOnly]
    def creationTime: Optional[Date]
    def lastUpdatedTime: Optional[Date]
    def createdBy: Optional[StringWithCharLimit256]
    def getConfigurationAggregatorName
        : ZIO[Any, AwsError, ConfigurationAggregatorName] =
      AwsError.unwrapOptionField(
        "configurationAggregatorName",
        configurationAggregatorName
      )
    def getConfigurationAggregatorArn
        : ZIO[Any, AwsError, ConfigurationAggregatorArn] =
      AwsError.unwrapOptionField(
        "configurationAggregatorArn",
        configurationAggregatorArn
      )
    def getAccountAggregationSources: ZIO[Any, AwsError, List[
      zio.aws.config.model.AccountAggregationSource.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "accountAggregationSources",
      accountAggregationSources
    )
    def getOrganizationAggregationSource: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.OrganizationAggregationSource.ReadOnly
    ] = AwsError.unwrapOptionField(
      "organizationAggregationSource",
      organizationAggregationSource
    )
    def getCreationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getCreatedBy: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("createdBy", createdBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConfigurationAggregator
  ) extends zio.aws.config.model.ConfigurationAggregator.ReadOnly {
    override val configurationAggregatorName
        : Optional[ConfigurationAggregatorName] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationAggregatorName())
      .map(value =>
        zio.aws.config.model.primitives.ConfigurationAggregatorName(value)
      )
    override val configurationAggregatorArn
        : Optional[ConfigurationAggregatorArn] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationAggregatorArn())
      .map(value =>
        zio.aws.config.model.primitives.ConfigurationAggregatorArn(value)
      )
    override val accountAggregationSources: Optional[
      List[zio.aws.config.model.AccountAggregationSource.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accountAggregationSources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.AccountAggregationSource.wrap(item)
        }.toList
      )
    override val organizationAggregationSource: Optional[
      zio.aws.config.model.OrganizationAggregationSource.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.organizationAggregationSource())
      .map(value =>
        zio.aws.config.model.OrganizationAggregationSource.wrap(value)
      )
    override val creationTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val lastUpdatedTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val createdBy: Optional[StringWithCharLimit256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit256(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConfigurationAggregator
  ): zio.aws.config.model.ConfigurationAggregator.ReadOnly = new Wrapper(impl)
}
