package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait AggregatedSourceType {
  def unwrap: software.amazon.awssdk.services.config.model.AggregatedSourceType
}
object AggregatedSourceType {
  def wrap(
      value: software.amazon.awssdk.services.config.model.AggregatedSourceType
  ): zio.aws.config.model.AggregatedSourceType = value match {
    case software.amazon.awssdk.services.config.model.AggregatedSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.AggregatedSourceType.ACCOUNT =>
      val r = ACCOUNT
      r
    case software.amazon.awssdk.services.config.model.AggregatedSourceType.ORGANIZATION =>
      val r = ORGANIZATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.config.model.AggregatedSourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.AggregatedSourceType =
      software.amazon.awssdk.services.config.model.AggregatedSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCOUNT extends zio.aws.config.model.AggregatedSourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.AggregatedSourceType =
      software.amazon.awssdk.services.config.model.AggregatedSourceType.ACCOUNT
  }
  case object ORGANIZATION extends zio.aws.config.model.AggregatedSourceType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.AggregatedSourceType =
      software.amazon.awssdk.services.config.model.AggregatedSourceType.ORGANIZATION
  }
}
