package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{AwsRegion, AccountId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConfigRuleComplianceSummaryFilters(
    accountId: Optional[AccountId] = Optional.Absent,
    awsRegion: Optional[AwsRegion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConfigRuleComplianceSummaryFilters = {
    import ConfigRuleComplianceSummaryFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConfigRuleComplianceSummaryFilters
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        awsRegion.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.awsRegion)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.ConfigRuleComplianceSummaryFilters.ReadOnly =
    zio.aws.config.model.ConfigRuleComplianceSummaryFilters
      .wrap(buildAwsValue())
}
object ConfigRuleComplianceSummaryFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConfigRuleComplianceSummaryFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConfigRuleComplianceSummaryFilters =
      zio.aws.config.model.ConfigRuleComplianceSummaryFilters(
        accountId.map(value => value),
        awsRegion.map(value => value)
      )
    def accountId: Optional[AccountId]
    def awsRegion: Optional[AwsRegion]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAwsRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConfigRuleComplianceSummaryFilters
  ) extends zio.aws.config.model.ConfigRuleComplianceSummaryFilters.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.config.model.primitives.AccountId(value))
    override val awsRegion: Optional[AwsRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.awsRegion())
      .map(value => zio.aws.config.model.primitives.AwsRegion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConfigRuleComplianceSummaryFilters
  ): zio.aws.config.model.ConfigRuleComplianceSummaryFilters.ReadOnly =
    new Wrapper(impl)
}
