package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  IncludeGlobalResourceTypes,
  AllSupported
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RecordingGroup(
    allSupported: Optional[AllSupported] = Optional.Absent,
    includeGlobalResourceTypes: Optional[IncludeGlobalResourceTypes] =
      Optional.Absent,
    resourceTypes: Optional[Iterable[zio.aws.config.model.ResourceType]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.RecordingGroup = {
    import RecordingGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.RecordingGroup
      .builder()
      .optionallyWith(
        allSupported.map(value => AllSupported.unwrap(value): java.lang.Boolean)
      )(_.allSupported)
      .optionallyWith(
        includeGlobalResourceTypes.map(value =>
          IncludeGlobalResourceTypes.unwrap(value): java.lang.Boolean
        )
      )(_.includeGlobalResourceTypes)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.resourceTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.config.model.RecordingGroup.ReadOnly =
    zio.aws.config.model.RecordingGroup.wrap(buildAwsValue())
}
object RecordingGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.RecordingGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.RecordingGroup =
      zio.aws.config.model.RecordingGroup(
        allSupported.map(value => value),
        includeGlobalResourceTypes.map(value => value),
        resourceTypes.map(value => value)
      )
    def allSupported: Optional[AllSupported]
    def includeGlobalResourceTypes: Optional[IncludeGlobalResourceTypes]
    def resourceTypes: Optional[List[zio.aws.config.model.ResourceType]]
    def getAllSupported: ZIO[Any, AwsError, AllSupported] =
      AwsError.unwrapOptionField("allSupported", allSupported)
    def getIncludeGlobalResourceTypes
        : ZIO[Any, AwsError, IncludeGlobalResourceTypes] =
      AwsError.unwrapOptionField(
        "includeGlobalResourceTypes",
        includeGlobalResourceTypes
      )
    def getResourceTypes
        : ZIO[Any, AwsError, List[zio.aws.config.model.ResourceType]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.RecordingGroup
  ) extends zio.aws.config.model.RecordingGroup.ReadOnly {
    override val allSupported: Optional[AllSupported] = zio.aws.core.internal
      .optionalFromNullable(impl.allSupported())
      .map(value => zio.aws.config.model.primitives.AllSupported(value))
    override val includeGlobalResourceTypes
        : Optional[IncludeGlobalResourceTypes] = zio.aws.core.internal
      .optionalFromNullable(impl.includeGlobalResourceTypes())
      .map(value =>
        zio.aws.config.model.primitives.IncludeGlobalResourceTypes(value)
      )
    override val resourceTypes
        : Optional[List[zio.aws.config.model.ResourceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.ResourceType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.RecordingGroup
  ): zio.aws.config.model.RecordingGroup.ReadOnly = new Wrapper(impl)
}
