package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  DeliveryS3KeyPrefix,
  ConformancePackName,
  DeliveryS3Bucket,
  TemplateS3Uri,
  TemplateBody
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutConformancePackRequest(
    conformancePackName: ConformancePackName,
    templateS3Uri: Optional[TemplateS3Uri] = Optional.Absent,
    templateBody: Optional[TemplateBody] = Optional.Absent,
    deliveryS3Bucket: Optional[DeliveryS3Bucket] = Optional.Absent,
    deliveryS3KeyPrefix: Optional[DeliveryS3KeyPrefix] = Optional.Absent,
    conformancePackInputParameters: Optional[
      Iterable[zio.aws.config.model.ConformancePackInputParameter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutConformancePackRequest = {
    import PutConformancePackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutConformancePackRequest
      .builder()
      .conformancePackName(
        ConformancePackName.unwrap(conformancePackName): java.lang.String
      )
      .optionallyWith(
        templateS3Uri.map(value =>
          TemplateS3Uri.unwrap(value): java.lang.String
        )
      )(_.templateS3Uri)
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        deliveryS3Bucket.map(value =>
          DeliveryS3Bucket.unwrap(value): java.lang.String
        )
      )(_.deliveryS3Bucket)
      .optionallyWith(
        deliveryS3KeyPrefix.map(value =>
          DeliveryS3KeyPrefix.unwrap(value): java.lang.String
        )
      )(_.deliveryS3KeyPrefix)
      .optionallyWith(
        conformancePackInputParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.conformancePackInputParameters)
      .build()
  }
  def asReadOnly: zio.aws.config.model.PutConformancePackRequest.ReadOnly =
    zio.aws.config.model.PutConformancePackRequest.wrap(buildAwsValue())
}
object PutConformancePackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutConformancePackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutConformancePackRequest =
      zio.aws.config.model.PutConformancePackRequest(
        conformancePackName,
        templateS3Uri.map(value => value),
        templateBody.map(value => value),
        deliveryS3Bucket.map(value => value),
        deliveryS3KeyPrefix.map(value => value),
        conformancePackInputParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def conformancePackName: ConformancePackName
    def templateS3Uri: Optional[TemplateS3Uri]
    def templateBody: Optional[TemplateBody]
    def deliveryS3Bucket: Optional[DeliveryS3Bucket]
    def deliveryS3KeyPrefix: Optional[DeliveryS3KeyPrefix]
    def conformancePackInputParameters: Optional[
      List[zio.aws.config.model.ConformancePackInputParameter.ReadOnly]
    ]
    def getConformancePackName: ZIO[Any, Nothing, ConformancePackName] =
      ZIO.succeed(conformancePackName)
    def getTemplateS3Uri: ZIO[Any, AwsError, TemplateS3Uri] =
      AwsError.unwrapOptionField("templateS3Uri", templateS3Uri)
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getDeliveryS3Bucket: ZIO[Any, AwsError, DeliveryS3Bucket] =
      AwsError.unwrapOptionField("deliveryS3Bucket", deliveryS3Bucket)
    def getDeliveryS3KeyPrefix: ZIO[Any, AwsError, DeliveryS3KeyPrefix] =
      AwsError.unwrapOptionField("deliveryS3KeyPrefix", deliveryS3KeyPrefix)
    def getConformancePackInputParameters: ZIO[Any, AwsError, List[
      zio.aws.config.model.ConformancePackInputParameter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "conformancePackInputParameters",
      conformancePackInputParameters
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutConformancePackRequest
  ) extends zio.aws.config.model.PutConformancePackRequest.ReadOnly {
    override val conformancePackName: ConformancePackName =
      zio.aws.config.model.primitives
        .ConformancePackName(impl.conformancePackName())
    override val templateS3Uri: Optional[TemplateS3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.templateS3Uri())
      .map(value => zio.aws.config.model.primitives.TemplateS3Uri(value))
    override val templateBody: Optional[TemplateBody] = zio.aws.core.internal
      .optionalFromNullable(impl.templateBody())
      .map(value => zio.aws.config.model.primitives.TemplateBody(value))
    override val deliveryS3Bucket: Optional[DeliveryS3Bucket] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliveryS3Bucket())
        .map(value => zio.aws.config.model.primitives.DeliveryS3Bucket(value))
    override val deliveryS3KeyPrefix: Optional[DeliveryS3KeyPrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliveryS3KeyPrefix())
        .map(value =>
          zio.aws.config.model.primitives.DeliveryS3KeyPrefix(value)
        )
    override val conformancePackInputParameters: Optional[
      List[zio.aws.config.model.ConformancePackInputParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.conformancePackInputParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.ConformancePackInputParameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutConformancePackRequest
  ): zio.aws.config.model.PutConformancePackRequest.ReadOnly = new Wrapper(impl)
}
