package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.Date
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class EvaluationResultIdentifier(
    evaluationResultQualifier: Optional[
      zio.aws.config.model.EvaluationResultQualifier
    ] = Optional.Absent,
    orderingTimestamp: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.EvaluationResultIdentifier = {
    import EvaluationResultIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.EvaluationResultIdentifier
      .builder()
      .optionallyWith(
        evaluationResultQualifier.map(value => value.buildAwsValue())
      )(_.evaluationResultQualifier)
      .optionallyWith(
        orderingTimestamp.map(value => Date.unwrap(value): Instant)
      )(_.orderingTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.config.model.EvaluationResultIdentifier.ReadOnly =
    zio.aws.config.model.EvaluationResultIdentifier.wrap(buildAwsValue())
}
object EvaluationResultIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.EvaluationResultIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.EvaluationResultIdentifier =
      zio.aws.config.model.EvaluationResultIdentifier(
        evaluationResultQualifier.map(value => value.asEditable),
        orderingTimestamp.map(value => value)
      )
    def evaluationResultQualifier
        : Optional[zio.aws.config.model.EvaluationResultQualifier.ReadOnly]
    def orderingTimestamp: Optional[Date]
    def getEvaluationResultQualifier: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.EvaluationResultQualifier.ReadOnly
    ] = AwsError.unwrapOptionField(
      "evaluationResultQualifier",
      evaluationResultQualifier
    )
    def getOrderingTimestamp: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("orderingTimestamp", orderingTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.EvaluationResultIdentifier
  ) extends zio.aws.config.model.EvaluationResultIdentifier.ReadOnly {
    override val evaluationResultQualifier
        : Optional[zio.aws.config.model.EvaluationResultQualifier.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationResultQualifier())
        .map(value =>
          zio.aws.config.model.EvaluationResultQualifier.wrap(value)
        )
    override val orderingTimestamp: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.orderingTimestamp())
      .map(value => zio.aws.config.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.EvaluationResultIdentifier
  ): zio.aws.config.model.EvaluationResultIdentifier.ReadOnly = new Wrapper(
    impl
  )
}
