package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.QueryName
import scala.jdk.CollectionConverters.*
final case class DeleteStoredQueryRequest(queryName: QueryName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DeleteStoredQueryRequest = {
    import DeleteStoredQueryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DeleteStoredQueryRequest
      .builder()
      .queryName(QueryName.unwrap(queryName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.config.model.DeleteStoredQueryRequest.ReadOnly =
    zio.aws.config.model.DeleteStoredQueryRequest.wrap(buildAwsValue())
}
object DeleteStoredQueryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DeleteStoredQueryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DeleteStoredQueryRequest =
      zio.aws.config.model.DeleteStoredQueryRequest(queryName)
    def queryName: QueryName
    def getQueryName: ZIO[Any, Nothing, QueryName] = ZIO.succeed(queryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DeleteStoredQueryRequest
  ) extends zio.aws.config.model.DeleteStoredQueryRequest.ReadOnly {
    override val queryName: QueryName =
      zio.aws.config.model.primitives.QueryName(impl.queryName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DeleteStoredQueryRequest
  ): zio.aws.config.model.DeleteStoredQueryRequest.ReadOnly = new Wrapper(impl)
}
