package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  AwsRegion,
  ResourceName,
  ResourceId,
  AccountId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResourceFilters(
    accountId: Optional[AccountId] = Optional.Absent,
    resourceId: Optional[ResourceId] = Optional.Absent,
    resourceName: Optional[ResourceName] = Optional.Absent,
    region: Optional[AwsRegion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ResourceFilters = {
    import ResourceFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ResourceFilters
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        resourceId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        resourceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resourceName)
      .optionallyWith(
        region.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.region)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ResourceFilters.ReadOnly =
    zio.aws.config.model.ResourceFilters.wrap(buildAwsValue())
}
object ResourceFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ResourceFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ResourceFilters =
      zio.aws.config.model.ResourceFilters(
        accountId.map(value => value),
        resourceId.map(value => value),
        resourceName.map(value => value),
        region.map(value => value)
      )
    def accountId: Optional[AccountId]
    def resourceId: Optional[ResourceId]
    def resourceName: Optional[ResourceName]
    def region: Optional[AwsRegion]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getResourceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ResourceFilters
  ) extends zio.aws.config.model.ResourceFilters.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.config.model.primitives.AccountId(value))
    override val resourceId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.config.model.primitives.ResourceId(value))
    override val resourceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceName())
      .map(value => zio.aws.config.model.primitives.ResourceName(value))
    override val region: Optional[AwsRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.config.model.primitives.AwsRegion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ResourceFilters
  ): zio.aws.config.model.ResourceFilters.ReadOnly = new Wrapper(impl)
}
