package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.StringWithCharLimit256
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetComplianceSummaryByResourceTypeRequest(
    resourceTypes: Optional[Iterable[StringWithCharLimit256]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeRequest = {
    import GetComplianceSummaryByResourceTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeRequest
      .builder()
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            StringWithCharLimit256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypes)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetComplianceSummaryByResourceTypeRequest.ReadOnly =
    zio.aws.config.model.GetComplianceSummaryByResourceTypeRequest
      .wrap(buildAwsValue())
}
object GetComplianceSummaryByResourceTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetComplianceSummaryByResourceTypeRequest =
      zio.aws.config.model.GetComplianceSummaryByResourceTypeRequest(
        resourceTypes.map(value => value)
      )
    def resourceTypes: Optional[List[StringWithCharLimit256]]
    def getResourceTypes: ZIO[Any, AwsError, List[StringWithCharLimit256]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeRequest
  ) extends zio.aws.config.model.GetComplianceSummaryByResourceTypeRequest.ReadOnly {
    override val resourceTypes: Optional[List[StringWithCharLimit256]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.primitives.StringWithCharLimit256(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeRequest
  ): zio.aws.config.model.GetComplianceSummaryByResourceTypeRequest.ReadOnly =
    new Wrapper(impl)
}
