package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeOrganizationConfigRuleStatusesResponse(
    organizationConfigRuleStatuses: Optional[
      Iterable[zio.aws.config.model.OrganizationConfigRuleStatus]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse = {
    import DescribeOrganizationConfigRuleStatusesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse
      .builder()
      .optionallyWith(
        organizationConfigRuleStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.organizationConfigRuleStatuses)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeOrganizationConfigRuleStatusesResponse.ReadOnly =
    zio.aws.config.model.DescribeOrganizationConfigRuleStatusesResponse
      .wrap(buildAwsValue())
}
object DescribeOrganizationConfigRuleStatusesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeOrganizationConfigRuleStatusesResponse =
      zio.aws.config.model.DescribeOrganizationConfigRuleStatusesResponse(
        organizationConfigRuleStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def organizationConfigRuleStatuses: Optional[
      List[zio.aws.config.model.OrganizationConfigRuleStatus.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getOrganizationConfigRuleStatuses: ZIO[Any, AwsError, List[
      zio.aws.config.model.OrganizationConfigRuleStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "organizationConfigRuleStatuses",
      organizationConfigRuleStatuses
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse
  ) extends zio.aws.config.model.DescribeOrganizationConfigRuleStatusesResponse.ReadOnly {
    override val organizationConfigRuleStatuses: Optional[
      List[zio.aws.config.model.OrganizationConfigRuleStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.organizationConfigRuleStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.OrganizationConfigRuleStatus.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse
  ): zio.aws.config.model.DescribeOrganizationConfigRuleStatusesResponse.ReadOnly =
    new Wrapper(impl)
}
