package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  QueryName,
  QueryExpression,
  QueryArn,
  QueryDescription,
  QueryId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StoredQuery(
    queryId: Optional[QueryId] = Optional.Absent,
    queryArn: Optional[QueryArn] = Optional.Absent,
    queryName: QueryName,
    description: Optional[QueryDescription] = Optional.Absent,
    expression: Optional[QueryExpression] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.StoredQuery = {
    import StoredQuery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.StoredQuery
      .builder()
      .optionallyWith(
        queryId.map(value => QueryId.unwrap(value): java.lang.String)
      )(_.queryId)
      .optionallyWith(
        queryArn.map(value => QueryArn.unwrap(value): java.lang.String)
      )(_.queryArn)
      .queryName(QueryName.unwrap(queryName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          QueryDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        expression.map(value => QueryExpression.unwrap(value): java.lang.String)
      )(_.expression)
      .build()
  }
  def asReadOnly: zio.aws.config.model.StoredQuery.ReadOnly =
    zio.aws.config.model.StoredQuery.wrap(buildAwsValue())
}
object StoredQuery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.StoredQuery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.StoredQuery =
      zio.aws.config.model.StoredQuery(
        queryId.map(value => value),
        queryArn.map(value => value),
        queryName,
        description.map(value => value),
        expression.map(value => value)
      )
    def queryId: Optional[QueryId]
    def queryArn: Optional[QueryArn]
    def queryName: QueryName
    def description: Optional[QueryDescription]
    def expression: Optional[QueryExpression]
    def getQueryId: ZIO[Any, AwsError, QueryId] =
      AwsError.unwrapOptionField("queryId", queryId)
    def getQueryArn: ZIO[Any, AwsError, QueryArn] =
      AwsError.unwrapOptionField("queryArn", queryArn)
    def getQueryName: ZIO[Any, Nothing, QueryName] = ZIO.succeed(queryName)
    def getDescription: ZIO[Any, AwsError, QueryDescription] =
      AwsError.unwrapOptionField("description", description)
    def getExpression: ZIO[Any, AwsError, QueryExpression] =
      AwsError.unwrapOptionField("expression", expression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.StoredQuery
  ) extends zio.aws.config.model.StoredQuery.ReadOnly {
    override val queryId: Optional[QueryId] = zio.aws.core.internal
      .optionalFromNullable(impl.queryId())
      .map(value => zio.aws.config.model.primitives.QueryId(value))
    override val queryArn: Optional[QueryArn] = zio.aws.core.internal
      .optionalFromNullable(impl.queryArn())
      .map(value => zio.aws.config.model.primitives.QueryArn(value))
    override val queryName: QueryName =
      zio.aws.config.model.primitives.QueryName(impl.queryName())
    override val description: Optional[QueryDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.config.model.primitives.QueryDescription(value))
    override val expression: Optional[QueryExpression] = zio.aws.core.internal
      .optionalFromNullable(impl.expression())
      .map(value => zio.aws.config.model.primitives.QueryExpression(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.StoredQuery
  ): zio.aws.config.model.StoredQuery.ReadOnly = new Wrapper(impl)
}
