package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceValueType {
  def unwrap: software.amazon.awssdk.services.config.model.ResourceValueType
}
object ResourceValueType {
  def wrap(
      value: software.amazon.awssdk.services.config.model.ResourceValueType
  ): zio.aws.config.model.ResourceValueType = value match {
    case software.amazon.awssdk.services.config.model.ResourceValueType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.ResourceValueType.RESOURCE_ID =>
      val r = RESOURCE_ID
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.config.model.ResourceValueType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceValueType =
      software.amazon.awssdk.services.config.model.ResourceValueType.UNKNOWN_TO_SDK_VERSION
  }
  case object RESOURCE_ID extends zio.aws.config.model.ResourceValueType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.ResourceValueType =
      software.amazon.awssdk.services.config.model.ResourceValueType.RESOURCE_ID
  }
}
