package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  ResourceName,
  ResourceId,
  AwsRegion,
  AccountId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AggregateResourceIdentifier(
    sourceAccountId: AccountId,
    sourceRegion: AwsRegion,
    resourceId: ResourceId,
    resourceType: zio.aws.config.model.ResourceType,
    resourceName: Optional[ResourceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.AggregateResourceIdentifier = {
    import AggregateResourceIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.AggregateResourceIdentifier
      .builder()
      .sourceAccountId(AccountId.unwrap(sourceAccountId): java.lang.String)
      .sourceRegion(AwsRegion.unwrap(sourceRegion): java.lang.String)
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .resourceType(resourceType.unwrap)
      .optionallyWith(
        resourceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resourceName)
      .build()
  }
  def asReadOnly: zio.aws.config.model.AggregateResourceIdentifier.ReadOnly =
    zio.aws.config.model.AggregateResourceIdentifier.wrap(buildAwsValue())
}
object AggregateResourceIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.AggregateResourceIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.AggregateResourceIdentifier =
      zio.aws.config.model.AggregateResourceIdentifier(
        sourceAccountId,
        sourceRegion,
        resourceId,
        resourceType,
        resourceName.map(value => value)
      )
    def sourceAccountId: AccountId
    def sourceRegion: AwsRegion
    def resourceId: ResourceId
    def resourceType: zio.aws.config.model.ResourceType
    def resourceName: Optional[ResourceName]
    def getSourceAccountId: ZIO[Any, Nothing, AccountId] =
      ZIO.succeed(sourceAccountId)
    def getSourceRegion: ZIO[Any, Nothing, AwsRegion] =
      ZIO.succeed(sourceRegion)
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getResourceType: ZIO[Any, Nothing, zio.aws.config.model.ResourceType] =
      ZIO.succeed(resourceType)
    def getResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.AggregateResourceIdentifier
  ) extends zio.aws.config.model.AggregateResourceIdentifier.ReadOnly {
    override val sourceAccountId: AccountId =
      zio.aws.config.model.primitives.AccountId(impl.sourceAccountId())
    override val sourceRegion: AwsRegion =
      zio.aws.config.model.primitives.AwsRegion(impl.sourceRegion())
    override val resourceId: ResourceId =
      zio.aws.config.model.primitives.ResourceId(impl.resourceId())
    override val resourceType: zio.aws.config.model.ResourceType =
      zio.aws.config.model.ResourceType.wrap(impl.resourceType())
    override val resourceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceName())
      .map(value => zio.aws.config.model.primitives.ResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.AggregateResourceIdentifier
  ): zio.aws.config.model.AggregateResourceIdentifier.ReadOnly = new Wrapper(
    impl
  )
}
